"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleTags = getRuleTags;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _esQuery = require("@kbn/es-query");
var _filters = require("../../../../rules_client/common/filters");
var _find_rules_so = require("../../../../data/rule/methods/find_rules_so");
var _ = require(".");
var _latest = require("../../../../../common/routes/rule/apis/tags/constants/latest");
var _authorization = require("../../../../authorization");
var _constants = require("../../../../rules_client/common/constants");
var _audit_events = require("../../../../rules_client/common/audit_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_TAGS = 10000;
async function getRuleTags(context, params) {
  var _response$aggregation, _response$aggregation2;
  let validatedParams;
  try {
    validatedParams = _.ruleTagsParamsSchema.validate(params);
  } catch (error) {
    throw _boom.default.badRequest(`Failed to validate params: ${error.message}`);
  }
  const {
    page,
    perPage = _latest.DEFAULT_TAGS_PER_PAGE,
    search = '',
    ruleTypeIds
  } = validatedParams;
  let authorizationTuple;
  try {
    authorizationTuple = await context.authorization.getFindAuthorizationFilter({
      authorizationEntity: _authorization.AlertingAuthorizationEntity.Rule,
      filterOpts: _constants.alertingAuthorizationFilterOpts
    });
  } catch (error) {
    var _context$auditLogger;
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
      action: _audit_events.RuleAuditAction.AGGREGATE,
      error
    }));
    throw error;
  }
  const {
    filter: authorizationFilter
  } = authorizationTuple;
  const ruleTypeIdsFilter = (0, _filters.buildRuleTypeIdsFilter)(ruleTypeIds);
  const searchFilter = Boolean(search) ? _esQuery.nodeBuilder.is('alert.attributes.tags', _esQuery.nodeTypes.wildcard.buildNode(`${search}*`)) : null;
  const combinedFilters = (0, _filters.combineFilters)([ruleTypeIdsFilter, searchFilter]);
  const filter = (0, _filters.combineFilterWithAuthorizationFilter)(combinedFilters, authorizationFilter);
  const response = await (0, _find_rules_so.findRulesSo)({
    savedObjectsClient: context.unsecuredSavedObjectsClient,
    savedObjectsFindOptions: {
      filter,
      aggs: {
        tags: {
          terms: {
            field: 'alert.attributes.tags',
            order: {
              _key: 'asc'
            },
            size: MAX_TAGS
          }
        }
      }
    }
  });
  const filteredTags = (((_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : (_response$aggregation2 = _response$aggregation.tags) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.buckets) || []).reduce((result, bucket) => {
    if (bucket.key.startsWith(search)) {
      result.push(bucket.key);
    }
    return result;
  }, []);
  const startIndex = (page - 1) * perPage;
  const endIndex = startIndex + perPage;
  const chunkedTags = filteredTags.slice(startIndex, endIndex);
  return {
    total: filteredTags.length,
    page,
    perPage,
    data: chunkedTags
  };
}