"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMaintenanceWindow = createMaintenanceWindow;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _server = require("@kbn/core/server");
var _esQuery = require("@kbn/es-query");
var _get_es_query_config = require("../../../../lib/get_es_query_config");
var _generate_maintenance_window_events = require("../../lib/generate_maintenance_window_events");
var _common = require("../../../../../common");
var _transforms = require("../../transforms");
var _maintenance_window = require("../../../../data/maintenance_window");
var _schemas = require("./schemas");
var _lib = require("../../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createMaintenanceWindow(context, params) {
  const {
    data
  } = params;
  const {
    savedObjectsClient,
    getModificationMetadata,
    logger,
    uiSettings
  } = context;
  const {
    title,
    duration,
    rRule,
    categoryIds,
    scopedQuery,
    enabled = true
  } = data;
  const esQueryConfig = await (0, _get_es_query_config.getEsQueryConfig)(uiSettings);
  try {
    _schemas.createMaintenanceWindowParamsSchema.validate(params);
  } catch (error) {
    throw _boom.default.badRequest(`Error validating create maintenance window data - ${error.message}`);
  }
  let scopedQueryWithGeneratedValue = scopedQuery;
  try {
    if (scopedQuery) {
      const dsl = JSON.stringify((0, _esQuery.buildEsQuery)(undefined, [{
        query: scopedQuery.kql,
        language: 'kuery'
      }], scopedQuery.filters, esQueryConfig));
      scopedQueryWithGeneratedValue = {
        ...scopedQuery,
        dsl
      };
    }
  } catch (error) {
    throw _boom.default.badRequest(`Error validating create maintenance window data - ${(0, _common.getScopedQueryErrorMessage)(error.message)}`);
  }
  const id = _server.SavedObjectsUtils.generateId();
  const expirationDate = (0, _lib.getMaintenanceWindowExpirationDate)({
    rRule,
    duration
  });
  const modificationMetadata = await getModificationMetadata();
  const events = (0, _generate_maintenance_window_events.generateMaintenanceWindowEvents)({
    rRule,
    expirationDate,
    duration
  });
  const maintenanceWindowAttributes = (0, _transforms.transformMaintenanceWindowToMaintenanceWindowAttributes)({
    title,
    enabled,
    expirationDate,
    categoryIds,
    scopedQuery: scopedQueryWithGeneratedValue,
    rRule: rRule,
    duration,
    events,
    ...modificationMetadata
  });
  try {
    const result = await (0, _maintenance_window.createMaintenanceWindowSo)({
      savedObjectsClient,
      maintenanceWindowAttributes,
      savedObjectsCreateOptions: {
        id
      }
    });
    return (0, _transforms.transformMaintenanceWindowAttributesToMaintenanceWindow)({
      attributes: result.attributes,
      id: result.id
    });
  } catch (e) {
    const errorMessage = `Failed to create maintenance window, Error: ${e}`;
    logger.error(errorMessage);
    throw _boom.default.boomify(e, {
      message: errorMessage
    });
  }
}