"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleBackfillResultsSchema = exports.scheduleBackfillResultSchema = exports.scheduleBackfillErrorSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _schemas = require("../../../result/schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scheduleBackfillErrorSchema = exports.scheduleBackfillErrorSchema = _configSchema.schema.object({
  error: _configSchema.schema.object({
    message: _configSchema.schema.string(),
    status: _configSchema.schema.maybe(_configSchema.schema.number()),
    rule: _configSchema.schema.object({
      id: _configSchema.schema.string(),
      name: _configSchema.schema.maybe(_configSchema.schema.string())
    })
  })
});
const scheduleBackfillResultSchema = exports.scheduleBackfillResultSchema = _configSchema.schema.oneOf([_schemas.backfillSchema, scheduleBackfillErrorSchema]);
const scheduleBackfillResultsSchema = exports.scheduleBackfillResultsSchema = _configSchema.schema.arrayOf(scheduleBackfillResultSchema);