"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runTask = void 0;
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const runTask = async (context, taskInstance, abortController) => {
  const runDate = new Date();
  try {
    const settings = taskInstance.params.settings;
    const spaceIds = taskInstance.params.spaceIds;
    if (!spaceIds || spaceIds.length === 0 || !settings) {
      throw new Error(`Invalid task parameters: ${JSON.stringify(taskInstance.params)}`);
    }
    for (const spaceId of spaceIds) {
      try {
        const {
          numAlertsDeleted,
          errors
        } = await (0, _.deleteAlertsForSpace)(context, settings, spaceId, abortController);
        if (errors && errors.length > 0) {
          (0, _.logFailedDeletion)(context, runDate, numAlertsDeleted, [spaceId], errors === null || errors === void 0 ? void 0 : errors.join(', '));
        } else {
          (0, _.logSuccessfulDeletion)(context, runDate, numAlertsDeleted, [spaceId]);
        }
      } catch (err) {
        (0, _.logFailedDeletion)(context, runDate, 0, taskInstance.params.spaceIds, err.message);
      }
    }
  } catch (err) {
    context.logger.error(`Error encountered while running alert deletion task: ${err.message}`, {
      error: {
        stack_trace: err.stack
      }
    });
    (0, _.logFailedDeletion)(context, runDate, 0, taskInstance.params.spaceIds, err.message);
  }
};
exports.runTask = runTask;