"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformMaintenanceWindowResponse = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformMaintenanceWindowResponse = response => {
  return {
    title: response.title,
    enabled: response.enabled,
    duration: response.duration,
    expirationDate: response.expiration_date,
    events: response.events,
    rRule: response.r_rule,
    ...(response.category_ids !== undefined ? {
      categoryIds: response.category_ids
    } : {}),
    ...(response.scoped_query !== undefined ? {
      scopedQuery: response.scoped_query
    } : {}),
    createdBy: response.created_by,
    updatedBy: response.updated_by,
    createdAt: response.created_at,
    updatedAt: response.updated_at,
    status: response.status,
    eventStartTime: response.event_start_time,
    eventEndTime: response.event_end_time,
    id: response.id
  };
};
exports.transformMaintenanceWindowResponse = transformMaintenanceWindowResponse;