"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicensePrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../translations"));
var _kibana_react = require("../../../utils/kibana_react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const title = /*#__PURE__*/_react.default.createElement("h2", {
  "data-test-subj": "license-prompt-title"
}, i18n.UPGRADE_TO_PLATINUM);
const LicensePrompt = exports.LicensePrompt = /*#__PURE__*/_react.default.memo(() => {
  const {
    application
  } = (0, _kibana_react.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    "data-test-subj": "mw-license-prompt",
    title: title,
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, i18n.UPGRADE_TO_PLATINUM_SUBTITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "license-prompt-upgrade",
      key: "upgrade-subscription-button",
      target: "_blank",
      href: "https://www.elastic.co/subscriptions"
    }, i18n.UPGRADE_SUBSCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      "data-test-subj": "license-prompt-trial",
      key: "start-trial-button",
      target: "_blank",
      href: application.getUrlForApp('management', {
        path: 'stack/license_management/home'
      })
    }, i18n.START_TRIAL)))))
  });
});
LicensePrompt.displayName = 'LicensePrompt';