"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateMaintenanceWindow = useUpdateMaintenanceWindow;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../utils/kibana_react");
var _update = require("../services/maintenance_windows_api/update");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useUpdateMaintenanceWindow(props) {
  const {
    onError
  } = props || {};
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const mutationFn = ({
    maintenanceWindowId,
    updateParams
  }) => {
    return (0, _update.updateMaintenanceWindow)({
      http,
      maintenanceWindowId,
      updateParams
    });
  };
  return (0, _reactQuery.useMutation)(mutationFn, {
    onSuccess: variables => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.alerting.maintenanceWindowsUpdateSuccess', {
        defaultMessage: "Updated maintenance window ''{title}''",
        values: {
          title: variables.title
        }
      }));
    },
    onError: error => {
      toasts.addDanger(_i18n.i18n.translate('xpack.alerting.maintenanceWindowsUpdateFailure', {
        defaultMessage: 'Failed to update maintenance window.'
      }));
      onError === null || onError === void 0 ? void 0 : onError(error);
    }
  });
}