"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformCustomScheduleToRRule = void 0;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _rrule = require("@kbn/rrule");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformEveryToFrequency = frequency => {
  switch (frequency) {
    case 'y':
      return _rrule.Frequency.YEARLY;
    case 'M':
      return _rrule.Frequency.MONTHLY;
    case 'w':
      return _rrule.Frequency.WEEKLY;
    case 'd':
      return _rrule.Frequency.DAILY;
    default:
      return;
  }
};
const getDurationInMilliseconds = duration => {
  var _duration$match;
  const [, durationNumber, durationUnit] = (_duration$match = duration.match(_constants.DURATION_REGEX)) !== null && _duration$match !== void 0 ? _duration$match : [];
  return _momentTimezone.default.duration(durationNumber, durationUnit).asMilliseconds();
};
const transformCustomScheduleToRRule = schedule => {
  var _recurring$every$matc, _recurring$every;
  const {
    recurring,
    duration,
    start,
    timezone
  } = schedule;
  const [, interval, frequency] = (_recurring$every$matc = recurring === null || recurring === void 0 ? void 0 : (_recurring$every = recurring.every) === null || _recurring$every === void 0 ? void 0 : _recurring$every.match(_constants.INTERVAL_FREQUENCY_REGEXP)) !== null && _recurring$every$matc !== void 0 ? _recurring$every$matc : [];
  const transformedFrequency = transformEveryToFrequency(frequency);
  const durationInMilliseconds = getDurationInMilliseconds(duration);
  return {
    duration: durationInMilliseconds,
    rRule: {
      byweekday: recurring === null || recurring === void 0 ? void 0 : recurring.onWeekDay,
      bymonthday: recurring === null || recurring === void 0 ? void 0 : recurring.onMonthDay,
      bymonth: recurring === null || recurring === void 0 ? void 0 : recurring.onMonth,
      until: recurring === null || recurring === void 0 ? void 0 : recurring.end,
      count: recurring === null || recurring === void 0 ? void 0 : recurring.occurrences,
      interval: interval ? parseInt(interval, 10) : undefined,
      freq: transformedFrequency,
      dtstart: start,
      tzid: timezone !== null && timezone !== void 0 ? timezone : _constants.DEFAULT_TIMEZONE
    }
  };
};
exports.transformCustomScheduleToRRule = transformCustomScheduleToRRule;