"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.typesRulesSchema = exports.typesRulesResponseSchema = exports.typesRulesResponseBodySchema = exports.actionVariableSchema = exports.actionGroupSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionVariableSchema = exports.actionVariableSchema = _configSchema.schema.object({
  name: _configSchema.schema.string(),
  description: _configSchema.schema.string(),
  usesPublicBaseUrl: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const actionGroupSchema = exports.actionGroupSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  name: _configSchema.schema.string()
}, {
  meta: {
    description: 'An action group to use when an alert goes from an active state to an inactive one.'
  }
});
const typesRulesSchema = exports.typesRulesSchema = _configSchema.schema.object({
  action_groups: _configSchema.schema.maybe(_configSchema.schema.arrayOf(actionGroupSchema, {
    meta: {
      description: "An explicit list of groups for which the rule type can schedule actions, each with the action group's unique ID and human readable name. Rule actions validation uses this configuration to ensure that groups are valid."
    }
  })),
  action_variables: _configSchema.schema.maybe(_configSchema.schema.object({
    context: _configSchema.schema.maybe(_configSchema.schema.arrayOf(actionVariableSchema)),
    state: _configSchema.schema.maybe(_configSchema.schema.arrayOf(actionVariableSchema)),
    params: _configSchema.schema.maybe(_configSchema.schema.arrayOf(actionVariableSchema))
  }, {
    meta: {
      description: 'A list of action variables that the rule type makes available via context and state in action parameter templates, and a short human readable description. When you create a rule in Kibana, it uses this information to prompt you for these variables in action parameter editors.'
    }
  })),
  alerts: _configSchema.schema.maybe(_configSchema.schema.object({
    context: _configSchema.schema.string({
      meta: {
        description: 'The namespace for this rule type.'
      }
    }),
    mappings: _configSchema.schema.maybe(_configSchema.schema.object({
      dynamic: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(false), _configSchema.schema.literal('strict')], {
        meta: {
          description: 'Indicates whether new fields are added dynamically.'
        }
      })),
      fieldMap: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any(), {
        meta: {
          description: 'Mapping information for each field supported in alerts as data documents for this rule type. For more information about mapping parameters, refer to the Elasticsearch documentation.'
        }
      }),
      shouldWrite: _configSchema.schema.maybe(_configSchema.schema.boolean({
        meta: {
          description: 'Indicates whether the rule should write out alerts as data.'
        }
      })),
      useEcs: _configSchema.schema.maybe(_configSchema.schema.boolean({
        meta: {
          description: 'Indicates whether to include the ECS component template for the alerts.'
        }
      }))
    }))
  }, {
    meta: {
      description: 'Details for writing alerts as data documents for this rule type.'
    }
  })),
  authorized_consumers: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
    read: _configSchema.schema.boolean(),
    all: _configSchema.schema.boolean()
  }), {
    meta: {
      description: 'The list of the plugins IDs that have access to the rule type.'
    }
  }),
  auto_recover_alerts: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  category: _configSchema.schema.string({
    meta: {
      description: 'The rule category, which is used by features such as category-specific maintenance windows.'
    }
  }),
  default_action_group_id: _configSchema.schema.string({
    meta: {
      description: 'The default identifier for the rule type group.'
    }
  }),
  default_schedule_interval: _configSchema.schema.maybe(_configSchema.schema.string()),
  does_set_recovery_context: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the rule passes context variables to its recovery action.'
    }
  })),
  enabled_in_license: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the rule type is enabled or disabled based on the subscription.'
    }
  }),
  fieldsForAAD: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  has_alerts_mappings: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the rule type has custom mappings for the alert data.'
    }
  }),
  has_fields_for_a_a_d: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the rule type has fields for alert as data for the alert data.  '
    }
  }),
  id: _configSchema.schema.string({
    meta: {
      description: 'The unique identifier for the rule type.'
    }
  }),
  is_exportable: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the rule type is exportable in Stack Management > Saved Objects.'
    }
  }),
  minimum_license_required: _configSchema.schema.oneOf([_configSchema.schema.literal('basic'), _configSchema.schema.literal('gold'), _configSchema.schema.literal('platinum'), _configSchema.schema.literal('standard'), _configSchema.schema.literal('enterprise'), _configSchema.schema.literal('trial')], {
    meta: {
      description: 'The subscriptions required to use the rule type.'
    }
  }),
  name: _configSchema.schema.string({
    meta: {
      description: 'The descriptive name of the rule type.'
    }
  }),
  producer: _configSchema.schema.string({
    meta: {
      description: 'An identifier for the application that produces this rule type.'
    }
  }),
  recovery_action_group: actionGroupSchema,
  rule_task_timeout: _configSchema.schema.maybe(_configSchema.schema.string())
});
const typesRulesResponseBodySchema = exports.typesRulesResponseBodySchema = _configSchema.schema.arrayOf(typesRulesSchema);
const typesRulesResponseSchema = exports.typesRulesResponseSchema = _configSchema.schema.object({
  body: typesRulesResponseBodySchema
});