"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.maintenanceWindowResponseSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _v = require("../constants/v1");
var _schedule = require("../../../../schedule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const maintenanceWindowResponseSchema = exports.maintenanceWindowResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string({
    meta: {
      description: 'The identifier for the maintenance window.'
    }
  }),
  title: _configSchema.schema.string({
    meta: {
      description: 'The name of the maintenance window.'
    }
  }),
  enabled: _configSchema.schema.boolean({
    meta: {
      description: 'Whether the current maintenance window is enabled. Disabled maintenance windows do not suppress notifications.'
    }
  }),
  created_by: _configSchema.schema.nullable(_configSchema.schema.string({
    meta: {
      description: 'The identifier for the user that created the maintenance window.'
    }
  })),
  updated_by: _configSchema.schema.nullable(_configSchema.schema.string({
    meta: {
      description: 'The identifier for the user that last updated this maintenance window.'
    }
  })),
  created_at: _configSchema.schema.string({
    meta: {
      description: 'The date and time when the maintenance window was created.'
    }
  }),
  updated_at: _configSchema.schema.string({
    meta: {
      description: 'The date and time when the maintenance window was last updated.'
    }
  }),
  status: _configSchema.schema.oneOf([_configSchema.schema.literal(_v.maintenanceWindowStatus.RUNNING), _configSchema.schema.literal(_v.maintenanceWindowStatus.UPCOMING), _configSchema.schema.literal(_v.maintenanceWindowStatus.FINISHED), _configSchema.schema.literal(_v.maintenanceWindowStatus.ARCHIVED)], {
    meta: {
      description: 'The current status of the maintenance window.'
    }
  }),
  scope: _configSchema.schema.maybe(_configSchema.schema.object({
    alerting: _configSchema.schema.object({
      query: _configSchema.schema.object({
        kql: _configSchema.schema.string({
          meta: {
            description: 'A filter written in Kibana Query Language (KQL).'
          }
        })
      })
    })
  })),
  schedule: _configSchema.schema.object({
    custom: _schedule.scheduleResponseSchemaV1
  })
});