"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaintenanceWindowStatus = exports.MANAGEMENT_APP_ID = exports.MAINTENANCE_WINDOW_SAVED_OBJECT_TYPE = exports.MAINTENANCE_WINDOW_PATHS = exports.MAINTENANCE_WINDOW_FEATURE_ID = exports.MAINTENANCE_WINDOW_DEFAULT_TABLE_ACTIVE_PAGE = exports.MAINTENANCE_WINDOW_DEFAULT_PER_PAGE = exports.MAINTENANCE_WINDOW_DEEP_LINK_IDS = exports.MAINTENANCE_WINDOW_DATE_FORMAT = exports.MAINTENANCE_WINDOW_API_PRIVILEGES = exports.MAINTENANCE_WINDOWS_APP_ID = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let MaintenanceWindowStatus = exports.MaintenanceWindowStatus = /*#__PURE__*/function (MaintenanceWindowStatus) {
  MaintenanceWindowStatus["Running"] = "running";
  MaintenanceWindowStatus["Upcoming"] = "upcoming";
  MaintenanceWindowStatus["Finished"] = "finished";
  MaintenanceWindowStatus["Archived"] = "archived";
  return MaintenanceWindowStatus;
}({});
/**
 * @deprecated Use the data/maintenance_window types instead
 */
/**
 * @deprecated Use the data/maintenance_window types instead
 */
/**
 * @deprecated Use the application/maintenance_window types instead
 */
const MAINTENANCE_WINDOW_SAVED_OBJECT_TYPE = exports.MAINTENANCE_WINDOW_SAVED_OBJECT_TYPE = 'maintenance-window';
const MAINTENANCE_WINDOW_FEATURE_ID = exports.MAINTENANCE_WINDOW_FEATURE_ID = 'maintenanceWindow';
const MAINTENANCE_WINDOW_API_PRIVILEGES = exports.MAINTENANCE_WINDOW_API_PRIVILEGES = {
  READ_MAINTENANCE_WINDOW: 'read-maintenance-window',
  WRITE_MAINTENANCE_WINDOW: 'write-maintenance-window'
};
const MAINTENANCE_WINDOWS_APP_ID = exports.MAINTENANCE_WINDOWS_APP_ID = 'maintenanceWindows';
const MANAGEMENT_APP_ID = exports.MANAGEMENT_APP_ID = 'management';
const MAINTENANCE_WINDOW_PATHS = exports.MAINTENANCE_WINDOW_PATHS = {
  alerting: {
    maintenanceWindows: `/${MAINTENANCE_WINDOWS_APP_ID}`,
    maintenanceWindowsCreate: '/create',
    maintenanceWindowsEdit: '/edit/:maintenanceWindowId'
  }
};
const MAINTENANCE_WINDOW_DEEP_LINK_IDS = exports.MAINTENANCE_WINDOW_DEEP_LINK_IDS = {
  maintenanceWindows: MAINTENANCE_WINDOWS_APP_ID,
  maintenanceWindowsCreate: 'create',
  maintenanceWindowsEdit: 'edit'
};
const MAINTENANCE_WINDOW_DATE_FORMAT = exports.MAINTENANCE_WINDOW_DATE_FORMAT = 'MM/DD/YY hh:mm A';
const MAINTENANCE_WINDOW_DEFAULT_PER_PAGE = exports.MAINTENANCE_WINDOW_DEFAULT_PER_PAGE = 10;
const MAINTENANCE_WINDOW_DEFAULT_TABLE_ACTIVE_PAGE = exports.MAINTENANCE_WINDOW_DEFAULT_TABLE_ACTIVE_PAGE = 1;