"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCasesPersistableState = registerCasesPersistableState;
var _constants = require("@kbn/aiops-change-point-detection/constants");
var _constants2 = require("@kbn/aiops-log-pattern-analysis/constants");
var _constants3 = require("@kbn/aiops-log-rate-analysis/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerCasesPersistableState(cases, logger) {
  if (cases) {
    try {
      cases.attachmentFramework.registerPersistableState({
        id: _constants.CASES_ATTACHMENT_CHANGE_POINT_CHART
      });
      cases.attachmentFramework.registerPersistableState({
        id: _constants2.CASES_ATTACHMENT_LOG_PATTERN
      });
      cases.attachmentFramework.registerPersistableState({
        id: _constants3.CASES_ATTACHMENT_LOG_RATE_ANALYSIS
      });
    } catch (error) {
      logger.warn(`AIOPs failed to register cases persistable state`);
    }
  }
}