"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupCapabilities = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setupCapabilities = (core, enabled) => {
  core.capabilities.registerProvider(() => {
    return {
      aiops: {
        enabled
      }
    };
  });
  core.capabilities.registerSwitcher(async (request, capabilities, useDefaultCapabilities) => {
    const [, {
      licensing
    }] = await core.getStartServices();
    const lic = await (0, _rxjs.firstValueFrom)(licensing.license$);
    if (lic.hasAtLeast('platinum') === false) {
      return {
        aiops: {
          enabled: false
        }
      };
    }
    return {};
  }, {
    capabilityPath: 'aiops.*'
  });
};
exports.setupCapabilities = setupCapabilities;