"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFailedTransactionsCorrelationImpactLabel = getFailedTransactionsCorrelationImpactLabel;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This is currently copied over from the APM plugin
const CORRELATIONS_IMPACT_THRESHOLD = {
  HIGH: _i18n.i18n.translate('xpack.aiops.correlations.highImpactText', {
    defaultMessage: 'High'
  }),
  MEDIUM: _i18n.i18n.translate('xpack.aiops.correlations.mediumImpactText', {
    defaultMessage: 'Medium'
  }),
  LOW: _i18n.i18n.translate('xpack.aiops.correlations.lowImpactText', {
    defaultMessage: 'Low'
  }),
  VERY_LOW: _i18n.i18n.translate('xpack.aiops.correlations.veryLowImpactText', {
    defaultMessage: 'Very low'
  })
};
function getFailedTransactionsCorrelationImpactLabel(pValue, isFallbackResult) {
  if (pValue === null) {
    return null;
  }
  if (isFallbackResult) return {
    impact: CORRELATIONS_IMPACT_THRESHOLD.VERY_LOW,
    color: 'default'
  };

  // The lower the p value, the higher the impact
  if (pValue >= 0 && pValue < 1e-6) return {
    impact: CORRELATIONS_IMPACT_THRESHOLD.HIGH,
    color: 'danger'
  };
  if (pValue >= 1e-6 && pValue < 0.001) return {
    impact: CORRELATIONS_IMPACT_THRESHOLD.MEDIUM,
    color: 'warning'
  };
  if (pValue >= 0.001 && pValue < 0.02) return {
    impact: CORRELATIONS_IMPACT_THRESHOLD.LOW,
    color: 'default'
  };
  return null;
}