"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.windowParametersToAppState = exports.getDefaultLogRateAnalysisAppState = exports.appStateToWindowParameters = void 0;
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * To avoid long urls, we store the window parameters in the url state not with
 * their full parameters names but with abbrevations. `windowParametersToAppState` and
 * `appStateToWindowParameters` are used to transform the data structure.
 */

/**
 * Transforms a full window parameters object to the abbreviated url state version.
 */
const windowParametersToAppState = wp => wp && {
  bMin: wp.baselineMin,
  bMax: wp.baselineMax,
  dMin: wp.deviationMin,
  dMax: wp.deviationMax
};

/**
 * Transforms an abbreviated url state version of window parameters to its full version.
 */
exports.windowParametersToAppState = windowParametersToAppState;
const appStateToWindowParameters = wp => wp && {
  baselineMin: wp.bMin,
  baselineMax: wp.bMax,
  deviationMin: wp.dMin,
  deviationMax: wp.dMax
};
exports.appStateToWindowParameters = appStateToWindowParameters;
const getDefaultLogRateAnalysisAppState = overrides => {
  return {
    wp: undefined,
    ...(0, _common.getDefaultAiOpsListState)(overrides)
  };
};
exports.getDefaultLogRateAnalysisAppState = getDefaultLogRateAnalysisAppState;