"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateLoadingState = exports.streamReducerActions = exports.streamReducer = exports.setZeroDocsFallback = exports.setCurrentAnalysisWindowParameters = exports.setCurrentAnalysisType = exports.resetResults = exports.resetGroups = exports.resetErrors = exports.ping = exports.logRateAnalysisResultsSlice = exports.getDefaultState = exports.addSignificantItemsHistogram = exports.addSignificantItemsGroupHistogram = exports.addSignificantItemsGroup = exports.addSignificantItems = exports.addError = void 0;
var _toolkit = require("@reduxjs/toolkit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultState = () => ({
  ccsWarning: false,
  significantItems: [],
  significantItemsGroups: [],
  errors: [],
  loaded: 0,
  loadingState: '',
  zeroDocsFallback: false
});
exports.getDefaultState = getDefaultState;
const logRateAnalysisResultsSlice = exports.logRateAnalysisResultsSlice = (0, _toolkit.createSlice)({
  name: 'logRateAnalysisResults',
  initialState: getDefaultState(),
  reducers: {
    addSignificantItems: (state, action) => {
      state.significantItems.push(...action.payload);
    },
    addSignificantItemsHistogram: (state, action) => {
      state.significantItems = state.significantItems.map(cp => {
        const cpHistogram = action.payload.find(h => h.fieldName === cp.fieldName && h.fieldValue === cp.fieldValue);
        return {
          ...cp,
          ...(cpHistogram ? {
            histogram: cpHistogram.histogram
          } : {})
        };
      });
    },
    addSignificantItemsGroup: (state, action) => {
      state.significantItemsGroups = action.payload;
    },
    addSignificantItemsGroupHistogram: (state, action) => {
      state.significantItemsGroups = state.significantItemsGroups.map(cpg => {
        const cpHistogram = action.payload.find(h => h.id === cpg.id);
        if (cpHistogram) {
          cpg.histogram = cpHistogram.histogram;
        }
        return cpg;
      });
    },
    addError: (state, action) => {
      state.errors.push(action.payload);
    },
    ping: () => {},
    resetErrors: state => {
      state.errors = [];
    },
    resetGroups: state => {
      state.significantItemsGroups = [];
    },
    // Reset the results but keep the current analysis type and window parameters.
    resetResults: state => ({
      ...getDefaultState(),
      currentAnalysisType: state.currentAnalysisType,
      currentAnalysisWindowParameters: state.currentAnalysisWindowParameters
    }),
    updateLoadingState: (state, action) => {
      return {
        ...state,
        ...action.payload
      };
    },
    setZeroDocsFallback: (state, action) => {
      state.zeroDocsFallback = action.payload;
    },
    setCurrentAnalysisType: (state, action) => {
      state.currentAnalysisType = action.payload;
    },
    setCurrentAnalysisWindowParameters: (state, action) => {
      state.currentAnalysisWindowParameters = action.payload;
    }
  }
});
const streamReducer = exports.streamReducer = logRateAnalysisResultsSlice.reducer;
const streamReducerActions = exports.streamReducerActions = logRateAnalysisResultsSlice.actions;
const {
  addError,
  addSignificantItems,
  addSignificantItemsGroup,
  addSignificantItemsGroupHistogram,
  addSignificantItemsHistogram,
  ping,
  resetResults,
  resetErrors,
  resetGroups,
  setCurrentAnalysisType,
  setCurrentAnalysisWindowParameters,
  setZeroDocsFallback,
  updateLoadingState
} = logRateAnalysisResultsSlice.actions;
exports.updateLoadingState = updateLoadingState;
exports.setZeroDocsFallback = setZeroDocsFallback;
exports.setCurrentAnalysisWindowParameters = setCurrentAnalysisWindowParameters;
exports.setCurrentAnalysisType = setCurrentAnalysisType;
exports.resetGroups = resetGroups;
exports.resetErrors = resetErrors;
exports.resetResults = resetResults;
exports.ping = ping;
exports.addSignificantItemsHistogram = addSignificantItemsHistogram;
exports.addSignificantItemsGroupHistogram = addSignificantItemsGroupHistogram;
exports.addSignificantItemsGroup = addSignificantItemsGroup;
exports.addSignificantItems = addSignificantItems;
exports.addError = addError;