"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findConnectorsSo = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findConnectorsSo = async ({
  savedObjectsClient,
  namespace
}) => {
  return savedObjectsClient.find({
    perPage: _constants.MAX_ACTIONS_RETURNED,
    type: 'action',
    ...(namespace ? {
      namespaces: [namespace]
    } : {})
  });
};
exports.findConnectorsSo = findConnectorsSo;