"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiPaletteYellow = exports.useEuiPaletteWarm = exports.useEuiPaletteSkyBlue = exports.useEuiPaletteRed = exports.useEuiPaletteOrange = exports.useEuiPaletteGreen = exports.useEuiPaletteGray = exports.useEuiPaletteForTemperature = exports.useEuiPaletteForStatus = exports.useEuiPaletteCool = exports.useEuiPaletteComplementary = exports.useEuiPaletteColorBlindBehindText = exports.useEuiPaletteColorBlind = void 0;
var _react = require("react");
var _hooks = require("../theme/hooks");
var _eui_palettes = require("./eui_palettes");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var useEuiPaletteColorBlind = exports.useEuiPaletteColorBlind = function useEuiPaletteColorBlind(args) {
  return _useEuiPaletteFn(_eui_palettes.euiPaletteColorBlind, args);
};
var useEuiPaletteColorBlindBehindText = exports.useEuiPaletteColorBlindBehindText = function useEuiPaletteColorBlindBehindText(args) {
  return _useEuiPaletteFn(_eui_palettes.euiPaletteColorBlindBehindText, args);
};
var useEuiPaletteForStatus = exports.useEuiPaletteForStatus = function useEuiPaletteForStatus(steps) {
  return _useEuiPaletteWithStepsFn(_eui_palettes.euiPaletteForStatus, steps);
};
var useEuiPaletteForTemperature = exports.useEuiPaletteForTemperature = function useEuiPaletteForTemperature(steps) {
  return _useEuiPaletteWithStepsFn(_eui_palettes.euiPaletteForTemperature, steps);
};
var useEuiPaletteComplementary = exports.useEuiPaletteComplementary = function useEuiPaletteComplementary(steps) {
  return _useEuiPaletteWithStepsFn(_eui_palettes.euiPaletteComplementary, steps);
};
var useEuiPaletteRed = exports.useEuiPaletteRed = function useEuiPaletteRed(steps) {
  return _useEuiPaletteWithStepsFn(_eui_palettes.euiPaletteRed, steps);
};
var useEuiPaletteGreen = exports.useEuiPaletteGreen = function useEuiPaletteGreen(steps) {
  return _useEuiPaletteWithStepsFn(_eui_palettes.euiPaletteGreen, steps);
};
var useEuiPaletteSkyBlue = exports.useEuiPaletteSkyBlue = function useEuiPaletteSkyBlue(steps) {
  return _useEuiPaletteWithStepsFn(_eui_palettes.euiPaletteSkyBlue, steps);
};
var useEuiPaletteYellow = exports.useEuiPaletteYellow = function useEuiPaletteYellow(steps) {
  return _useEuiPaletteWithStepsFn(_eui_palettes.euiPaletteYellow, steps);
};
var useEuiPaletteOrange = exports.useEuiPaletteOrange = function useEuiPaletteOrange(steps) {
  return _useEuiPaletteWithStepsFn(_eui_palettes.euiPaletteOrange, steps);
};
var useEuiPaletteCool = exports.useEuiPaletteCool = function useEuiPaletteCool(steps) {
  return _useEuiPaletteWithStepsFn(_eui_palettes.euiPaletteCool, steps);
};
var useEuiPaletteWarm = exports.useEuiPaletteWarm = function useEuiPaletteWarm(steps) {
  return _useEuiPaletteWithStepsFn(_eui_palettes.euiPaletteWarm, steps);
};
var useEuiPaletteGray = exports.useEuiPaletteGray = function useEuiPaletteGray(steps) {
  return _useEuiPaletteWithStepsFn(_eui_palettes.euiPaletteGray, steps);
};

/* Internal helper utils */

var _useEuiPaletteFn = function _useEuiPaletteFn(palleteFn, args) {
  var _useEuiTheme = (0, _hooks.useEuiTheme)(),
    euiTheme = _useEuiTheme.euiTheme;
  var colors = euiTheme.colors,
    flags = euiTheme.flags;
  return (0, _react.useMemo)(function () {
    return palleteFn(_objectSpread(_objectSpread({}, args), {}, {
      colors: colors.vis,
      hasVisColorAdjustment: flags.hasVisColorAdjustment
    }));
  }, [colors, flags, args, palleteFn]);
};
var _useEuiPaletteWithStepsFn = function _useEuiPaletteWithStepsFn(palleteFn, steps) {
  var _useEuiTheme2 = (0, _hooks.useEuiTheme)(),
    euiTheme = _useEuiTheme2.euiTheme;
  var colors = euiTheme.colors,
    flags = euiTheme.flags;
  return (0, _react.useMemo)(function () {
    return palleteFn(steps, {
      colors: colors.vis,
      hasVisColorAdjustment: flags.hasVisColorAdjustment
    });
  }, [colors, flags, steps, palleteFn]);
};