"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiTableVariables = exports.euiTableStyles = exports.euiTableCaptionStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiTableVariables = exports.euiTableVariables = function euiTableVariables(_ref4) {
  var euiTheme = _ref4.euiTheme;
  var cellContentPadding = euiTheme.size.s;
  var compressedCellContentPadding = euiTheme.size.xs;
  var mobileSizes = {
    actions: {
      width: euiTheme.size.xxl,
      offset: (0, _global_styling.mathWithUnits)(cellContentPadding, function (x) {
        return x * 2;
      })
    },
    checkbox: {
      width: (0, _global_styling.mathWithUnits)([euiTheme.size.xl, euiTheme.size.xs], function (x, y) {
        return x + y;
      }),
      offset: (0, _global_styling.mathWithUnits)(cellContentPadding, function (x) {
        return x / 2;
      })
    }
  };
  var checkboxSize = euiTheme.size.xl;
  return {
    cellContentPadding: cellContentPadding,
    compressedCellContentPadding: compressedCellContentPadding,
    mobileSizes: mobileSizes,
    checkboxSize: checkboxSize
  };
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "gt2v1c-mobile",
  styles: "thead{display:none;}tfoot{display:none;};label:mobile;"
} : {
  name: "gt2v1c-mobile",
  styles: "thead{display:none;}tfoot{display:none;};label:mobile;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "18uoljc-auto",
  styles: "table-layout:auto;label:auto;"
} : {
  name: "18uoljc-auto",
  styles: "table-layout:auto;label:auto;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "1fm6zfw-fixed",
  styles: "table-layout:fixed;label:fixed;"
} : {
  name: "1fm6zfw-fixed",
  styles: "table-layout:fixed;label:fixed;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiTableStyles = exports.euiTableStyles = function euiTableStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiTableVariables = euiTableVariables(euiThemeContext),
    cellContentPadding = _euiTableVariables.cellContentPadding,
    compressedCellContentPadding = _euiTableVariables.compressedCellContentPadding;
  return {
    euiTable: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiNumberFormat)(euiThemeContext), " ", (0, _global_styling.logicalCSS)('width', '100%'), " border:none;border-collapse:collapse;background-color:", euiTheme.colors.emptyShade, ";;label:euiTable;"),
    layout: {
      fixed: _ref3,
      auto: _ref2
    },
    /**
     * 1. The padding on the `.euiTableCellContent` div allows the ellipsis to show if the
     * content is truncated. If the padding was on the cell, the ellipsis would be cropped.
     * 2. The `:where()` selector sets the specificity to 0, allowing consumers to more easily
     * override our CSS if needed
     */
    uncompressed: /*#__PURE__*/(0, _react.css)("font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 's').fontSize, ";line-height:", (0, _global_styling.euiFontSize)(euiThemeContext, 'm').lineHeight, ";& :where(.euiTableCellContent){padding:", cellContentPadding, ";};label:uncompressed;"),
    compressed: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 'xs'), "& :where(.euiTableCellContent){padding:", compressedCellContentPadding, ";};label:compressed;"),
    /**
     * Responsive/mobile vs desktop styles
     * Individual row/cells handle their own desktop vs mobile styles
     */
    desktop: /*#__PURE__*/(0, _react.css)(";label:desktop;"),
    mobile: _ref
  };
};

// The table caption needs to not be absolutely positioned, because for some reason
// it causes weird layout issues/double borders when used within a <table>
// Also needs to be !important to override euiScreenReaderOnly absolute positioning
var euiTableCaptionStyles = exports.euiTableCaptionStyles = process.env.NODE_ENV === "production" ? {
  name: "1hnio98-euiTableCaptionStyles",
  styles: "position:relative!important;label:euiTableCaptionStyles;"
} : {
  name: "1hnio98-euiTableCaptionStyles",
  styles: "position:relative!important;label:euiTableCaptionStyles;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};