"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiResizableButtonStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _high_contrast = require("../../global_styling/functions/high_contrast");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1fvu7sv-end",
  styles: "align-items:flex-end;label:end;"
} : {
  name: "1fvu7sv-end",
  styles: "align-items:flex-end;label:end;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "h0ntv8-start",
  styles: "align-items:flex-start;label:start;"
} : {
  name: "h0ntv8-start",
  styles: "align-items:flex-start;label:start;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "8391db-center",
  styles: "align-items:center;label:center;"
} : {
  name: "8391db-center",
  styles: "align-items:center;label:center;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiResizableButtonStyles = exports.euiResizableButtonStyles = function euiResizableButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var buttonSize = euiTheme.size.base;
  var negativeMargin = (0, _global_styling.mathWithUnits)(buttonSize, function (x) {
    return x / -2;
  });
  var grabHandleWidth = euiTheme.size.m;
  var grabHandleHeight = euiTheme.border.width.thin;
  var transitionSpeed = euiTheme.animation.fast;
  var transition = "".concat(transitionSpeed, " ease");
  return {
    // Creates a resizable indicator (either a grab handle or a plain border) with CSS psuedo-elements.
    // 1. The "grab" handle transforms into a thicker straight line on :hover and :focus
    // 2. Start/end aligned grab handles should have a slight margin offset that disappears on hover/focus
    // 3. CSS hack to smooth out/anti-alias the 1px wide handles at various zoom levels
    // 4. High contrast modes should not rely on background-color to indicate focus state, but on border width
    euiResizableButton: /*#__PURE__*/(0, _react.css)("z-index:1;flex-shrink:0;display:flex;justify-content:center;", (0, _high_contrast.preventForcedColors)(euiThemeContext), "&:disabled{display:none;}&::before,&::after{content:'';display:block;", _global_styling.euiCanAnimate, "{transition:width ", transition, ",height ", transition, ",margin ", transition, ",background-color ", transition, ";}}", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      /* 4 */
      none: "\n          &:hover {\n            &::before,\n            &::after {\n              background-color: ".concat(euiTheme.colors.mediumShade, ";\n            }\n          }")
    }), "&:focus,&:active{", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      /* 4 */
      none: "\n            background-color: ".concat((0, _services.transparentize)(euiTheme.colors.primary, 0.1), ";\n\n            &::before,\n            &::after {\n              background-color: ").concat(euiTheme.colors.primary, ";\n            }\n          ")
    }), " &::before,&::after{", _global_styling.euiCanAnimate, "{transition:width ", transition, ",height ", transition, ";transition-delay:", (0, _global_styling.mathWithUnits)(transitionSpeed, function (x) {
      return x / 2;
    }), ";}}};label:euiResizableButton;"),
    horizontal: /*#__PURE__*/(0, _react.css)("cursor:col-resize;", (0, _global_styling.logicalCSS)('height', '100%'), " ", (0, _global_styling.logicalCSS)('width', buttonSize), ";;label:horizontal;"),
    vertical: /*#__PURE__*/(0, _react.css)("flex-direction:column;cursor:row-resize;", (0, _global_styling.logicalCSS)('width', '100%'), " ", (0, _global_styling.logicalCSS)('height', buttonSize), ";;label:vertical;"),
    accountForScrollbars: {
      horizontal: {
        both: /*#__PURE__*/(0, _react.css)(";label:both;"),
        before: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-right', negativeMargin), ";label:before;"),
        after: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-left', negativeMargin), ";label:after;"),
        none: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-horizontal', negativeMargin), ";label:none;")
      },
      vertical: {
        both: /*#__PURE__*/(0, _react.css)(";label:both;"),
        before: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-bottom', negativeMargin), ";label:before;"),
        after: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-top', negativeMargin), ";label:after;"),
        none: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-vertical', negativeMargin), ";label:none;")
      }
    },
    border: /*#__PURE__*/(0, _react.css)("&::before,&::after{background-color:", euiTheme.border.color, ";};label:border;"),
    borderDirection: {
      horizontal: /*#__PURE__*/(0, _react.css)("&::before{", (0, _global_styling.logicalCSS)('width', euiTheme.border.width.thin), " ", (0, _global_styling.logicalCSS)('height', '100%'), ";}&:hover,&:focus,&:active{&::after{", (0, _global_styling.logicalCSS)('width', euiTheme.border.width.thin), " ", (0, _global_styling.logicalCSS)('height', '100%'), ";}}", _highContrastForcedBorder(euiThemeContext, 'horizontal'), ";;label:horizontal;"),
      vertical: /*#__PURE__*/(0, _react.css)("&::before{", (0, _global_styling.logicalCSS)('height', euiTheme.border.width.thin), " ", (0, _global_styling.logicalCSS)('width', '100%'), ";}&:hover,&:focus,&:active{&::after{", (0, _global_styling.logicalCSS)('height', euiTheme.border.width.thin), " ", (0, _global_styling.logicalCSS)('width', '100%'), ";}}", _highContrastForcedBorder(euiThemeContext, 'vertical'), ";;label:vertical;")
    },
    handle: /*#__PURE__*/(0, _react.css)("gap:", (0, _global_styling.mathWithUnits)(grabHandleHeight, function (x) {
      return x * 2;
    }), ";&:hover,&:focus,&:active{gap:0;}", _global_styling.euiCanAnimate, "{transition:gap ", transition, ";}&::before,&::after{background-color:", euiTheme.colors.darkestShade, ";transform:translateZ(0);}&:hover{&::before,&::after{", _global_styling.euiCanAnimate, "{transition-delay:", transitionSpeed, ";}}};label:handle;"),
    handleDirection: {
      horizontal: /*#__PURE__*/(0, _react.css)("&::before,&::after{", (0, _global_styling.logicalCSS)('width', grabHandleHeight), " ", (0, _global_styling.logicalCSS)('height', grabHandleWidth), " margin-block:", euiTheme.size.base, ";}&:hover,&:focus,&:active{&::before,&::after{", (0, _global_styling.logicalCSS)('height', '100%'), " margin-block:0;transform:none;}}", _highContrastForcedBorder(euiThemeContext, 'horizontal'), ";;label:horizontal;"),
      vertical: /*#__PURE__*/(0, _react.css)("&::before,&::after{", (0, _global_styling.logicalCSS)('height', grabHandleHeight), " ", (0, _global_styling.logicalCSS)('width', grabHandleWidth), " margin-inline:", euiTheme.size.base, ";}&:hover,&:focus,&:active{&::before,&::after{", (0, _global_styling.logicalCSS)('width', '100%'), " margin-inline:0;transform:none;}}", _highContrastForcedBorder(euiThemeContext, 'vertical'), ";;label:vertical;")
    },
    alignIndicator: {
      center: _ref3,
      start: _ref2,
      end: _ref
    }
  };
};

/* 4 */
var _highContrastForcedBorder = function _highContrastForcedBorder(euiThemeContext, direction) {
  var highContrastMode = euiThemeContext.highContrastMode,
    euiTheme = euiThemeContext.euiTheme;
  if (!highContrastMode) return '';
  var dimension = direction === 'horizontal' ? 'width' : 'height';
  return "\n    &:focus, &:active {\n      &::before, &::after {\n        ".concat((0, _global_styling.logicalCSS)(dimension, euiTheme.border.width.thick), "\n        background-color: ").concat(highContrastMode === 'forced' ? euiTheme.border.color : euiTheme.colors.primary, ";\n      }\n    }\n  ");
};