"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.panelPaddingOffset = exports.euiPopoverFooterStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiPopoverFooterStyles = exports.euiPopoverFooterStyles = function euiPopoverFooterStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  return {
    // Base
    euiPopoverFooter: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 's'), " ", (0, _global_styling.logicalCSS)('border-top', "".concat(euiTheme.border.width.thin, " solid ").concat(highContrastMode ? euiTheme.border.color : euiTheme.components.popoverFooterBorderColor)), ";;label:euiPopoverFooter;"),
    // If the popover's containing panel has padding applied,
    // ensure the title expands to cover that padding via negative margins
    panelPaddingSizes: {
      none: /*#__PURE__*/(0, _react.css)(";label:none;"),
      xs: /*#__PURE__*/(0, _react.css)(panelPaddingOffset(euiThemeContext, 'xs'), ";;label:xs;"),
      s: /*#__PURE__*/(0, _react.css)(panelPaddingOffset(euiThemeContext, 's'), ";;label:s;"),
      m: /*#__PURE__*/(0, _react.css)(panelPaddingOffset(euiThemeContext, 'm'), ";;label:m;"),
      l: /*#__PURE__*/(0, _react.css)(panelPaddingOffset(euiThemeContext, 'l'), ";;label:l;"),
      xl: /*#__PURE__*/(0, _react.css)(panelPaddingOffset(euiThemeContext, 'xl'), ";;label:xl;")
    }
  };
};
var panelPaddingOffset = exports.panelPaddingOffset = function panelPaddingOffset(euiThemeContext, size) {
  var panelPaddingSize = (0, _global_styling.euiPaddingSize)(euiThemeContext, size);
  return (0, _global_styling.logicalShorthandCSS)('margin', "".concat(panelPaddingSize, " -").concat(panelPaddingSize, " -").concat(panelPaddingSize));
};