"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._canRenderHighContrastBorder = exports.SIZES = exports.EuiPanel = exports.COLORS = exports.BORDER_RADII = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _common = require("../common");
var _panel = require("./panel.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "paddingSize", "borderRadius", "color", "hasShadow", "hasBorder", "grow", "panelRef", "element"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var SIZES = exports.SIZES = _global_styling.PADDING_SIZES;

// Exported padding sizes and class names necessary for EuiPopover and EuiCard.
// Which currently will only maintain support for the original values until conversion.
var paddingSizeToClassNameMap = {
  none: null,
  s: 'paddingSmall',
  m: 'paddingMedium',
  l: 'paddingLarge'
};
var _SIZES = (0, _common.keysOf)(paddingSizeToClassNameMap);
var BORDER_RADII = exports.BORDER_RADII = ['none', 'm'];
var COLORS = exports.COLORS = _global_styling.BACKGROUND_COLORS;
var EuiPanel = exports.EuiPanel = function EuiPanel(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'm' : _ref$paddingSize,
    _ref$borderRadius = _ref.borderRadius,
    borderRadius = _ref$borderRadius === void 0 ? 'm' : _ref$borderRadius,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'plain' : _ref$color,
    _ref$hasShadow = _ref.hasShadow,
    hasShadow = _ref$hasShadow === void 0 ? true : _ref$hasShadow,
    _ref$hasBorder = _ref.hasBorder,
    hasBorder = _ref$hasBorder === void 0 ? false : _ref$hasBorder,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    panelRef = _ref.panelRef,
    element = _ref.element,
    rest = _objectWithoutProperties(_ref, _excluded);
  // Add borders to panels in high contrast mode
  var _useEuiTheme = (0, _services.useEuiTheme)(),
    highContrastMode = _useEuiTheme.highContrastMode,
    euiTheme = _useEuiTheme.euiTheme;
  var borderColors = (0, _global_styling.useEuiBorderColorCSS)();

  // Shadows are only allowed when there's a white background (plain)
  var canHaveShadow = !hasBorder && color === 'plain' && !highContrastMode;
  var canHaveBorder = color === 'plain' || color === 'transparent';
  var styles = (0, _services.useEuiMemoizedStyles)(_panel.euiPanelStyles);
  var cssStyles = [styles.euiPanel, grow && styles.grow, styles.radius[borderRadius], (0, _global_styling.useEuiPaddingCSS)()[paddingSize], (0, _global_styling.useEuiBackgroundColorCSS)()[color], canHaveShadow && hasShadow === true && styles.hasShadow, canHaveBorder && hasBorder === true && styles.hasBorder].concat(_toConsumableArray(highContrastMode && _canRenderHighContrastBorder({
    color: color,
    hasBorder: hasBorder
  }) ? [{
    border: euiTheme.border.thin
  }, borderColors[color]] : []), [rest.onClick && styles.isClickable]);
  var classes = (0, _classnames.default)('euiPanel', "euiPanel--".concat(color), _defineProperty({}, "euiPanel--".concat(paddingSizeToClassNameMap[paddingSize]), paddingSizeToClassNameMap[paddingSize]), className);
  if (rest.onClick && element !== 'div') {
    return (0, _react2.jsx)("button", _extends({
      ref: panelRef,
      className: classes,
      css: cssStyles
    }, rest), children);
  }
  return (0, _react2.jsx)("div", _extends({
    ref: panelRef,
    className: classes,
    css: cssStyles
  }, rest), children);
};

// Do not render a high contrast border if the panel is transparent
// and does not have a default contrast border
EuiPanel.propTypes = {
  element: _propTypes.default.oneOfType([_propTypes.default.oneOf(["button"]), _propTypes.default.oneOf(["div"])]),
  /**
     * Adds a medium shadow to the panel;
     * Only works when `color="plain"`
     */
  /**
     * Adds a medium shadow to the panel;
     * Only works when `color="plain"`
     */
  hasShadow: _propTypes.default.bool,
  /**
     * Adds a slight 1px border on all edges.
     * Only works when `color="plain | transparent"`
     */
  /**
     * Adds a slight 1px border on all edges.
     * Only works when `color="plain | transparent"`
     */
  hasBorder: _propTypes.default.bool,
  /**
     * Padding for all four sides
     */
  /**
     * Padding for all four sides
     */
  paddingSize: _propTypes.default.any,
  /**
     * Corner border radius
     */
  /**
     * Corner border radius
     */
  borderRadius: _propTypes.default.any,
  /**
     * When true the panel will grow in height to match `EuiFlexItem`
     */
  /**
     * When true the panel will grow in height to match `EuiFlexItem`
     */
  grow: _propTypes.default.bool,
  panelRef: _propTypes.default.any,
  /**
     * Background color of the panel;
     * Usually a lightened form of the brand colors
     */
  /**
     * Background color of the panel;
     * Usually a lightened form of the brand colors
     */
  color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.oneOf(["highlighted"])]),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};
var _canRenderHighContrastBorder = exports._canRenderHighContrastBorder = function _canRenderHighContrastBorder(_ref2) {
  var color = _ref2.color,
    hasBorder = _ref2.hasBorder;
  return !(color === 'transparent' && !hasBorder);
};