"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultEuiMarkdownProcessingPlugins = exports.defaultProcessingPlugins = void 0;
var _react = _interopRequireWildcard(require("react"));
var _all = _interopRequireDefault(require("mdast-util-to-hast/lib/all"));
var _rehypeReact = _interopRequireDefault(require("rehype-react"));
var _remarkRehype = _interopRequireDefault(require("remark-rehype"));
var _link = require("../../../link");
var _code = require("../../../code");
var _horizontal_rule = require("../../../horizontal_rule");
var _remark_prismjs = require("../remark/remark_prismjs");
var MarkdownTooltip = _interopRequireWildcard(require("../markdown_tooltip"));
var MarkdownCheckbox = _interopRequireWildcard(require("../markdown_checkbox"));
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ // Importing seemingly unused types from `unified` because the definitions
// are exported for two versions of TypeScript (3.4, 4.0) and implicit
// imports during eui.d.ts generation default to the incorrect version (3.4).
// Explicit imports here resolve the version mismatch.
var unknownHandler = function unknownHandler(h, node) {
  return h(node, node.type, node, (0, _all.default)(h, node));
};
var DEFAULT_COMPONENT_RENDERERS = {
  checkbox: MarkdownCheckbox.renderer,
  tooltip: MarkdownTooltip.renderer
};
var getDefaultEuiMarkdownProcessingPlugins = exports.getDefaultEuiMarkdownProcessingPlugins = function getDefaultEuiMarkdownProcessingPlugins() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
    exclude = _ref.exclude,
    linkProps = _ref.linkProps;
  var componentPluginsWithExclusions = {};
  Object.entries(DEFAULT_COMPONENT_RENDERERS).forEach(function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
      excludeName = _ref3[0],
      renderer = _ref3[1];
    if (!(exclude !== null && exclude !== void 0 && exclude.includes(excludeName))) {
      var pluginName = "".concat(excludeName, "Plugin");
      componentPluginsWithExclusions[pluginName] = renderer;
    }
  });
  var plugins = [[_remarkRehype.default, {
    allowDangerousHtml: true,
    unknownHandler: unknownHandler,
    handlers: {} // intentionally empty, allows plugins to extend if they need to
  }], [_rehypeReact.default, {
    createElement: _react.createElement,
    Fragment: _react.Fragment,
    components: _objectSpread({
      a: function a(props) {
        return (0, _react2.jsx)(_link.EuiLink, _extends({}, props, linkProps));
      },
      code: function code(props) {
        return (
          // If there are linebreaks use codeblock, otherwise code
          /\r|\n/.exec(props.children) || props.className && props.className.indexOf(_remark_prismjs.FENCED_CLASS) > -1 ? (0, _react2.jsx)(_code.EuiCodeBlock, _extends({
            fontSize: "m",
            paddingSize: "s",
            isCopyable: true
          }, props)) : (0, _react2.jsx)(_code.EuiCode, props)
        );
      },
      // When we use block code "fences" the code tag is replaced by the `EuiCodeBlock`.
      // But there's a `pre` tag wrapping all the `EuiCodeBlock`.
      // We want to replace this `pre` tag with a `div` because the `EuiCodeBlock` has its own children `pre` tag.
      pre: function pre(props) {
        return (0, _react2.jsx)("div", _extends({}, props, {
          className: "euiMarkdownFormat__codeblockWrapper"
        }));
      },
      blockquote: function blockquote(props) {
        return (0, _react2.jsx)("blockquote", _extends({}, props, {
          className: "euiMarkdownFormat__blockquote"
        }));
      },
      table: function table(props) {
        return (0, _react2.jsx)("table", _extends({
          className: "euiMarkdownFormat__table"
        }, props));
      },
      hr: function hr(props) {
        return (0, _react2.jsx)(_horizontal_rule.EuiHorizontalRule, props);
      }
    }, componentPluginsWithExclusions)
  }]];
  return plugins;
};
var defaultProcessingPlugins = exports.defaultProcessingPlugins = getDefaultEuiMarkdownProcessingPlugins();