"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HEADINGS = exports.EuiInlineEditTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _title = require("../title");
var _inline_edit_form = require("./inline_edit_form");
var _inline_edit_title = require("./inline_edit_title.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "size", "heading", "readModeProps", "isReadOnly"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var HEADINGS = exports.HEADINGS = ['h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'span'];
var EuiInlineEditTitle = exports.EuiInlineEditTitle = function EuiInlineEditTitle(_ref) {
  var className = _ref.className,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    heading = _ref.heading,
    _readModeProps = _ref.readModeProps,
    isReadOnly = _ref.isReadOnly,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiInlineEditTitle', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_inline_edit_title.euiInlineEditTitleStyles);
  var cssStyles = [styles.euiInlineEditTitle, styles.fontSize[size]];
  var H = heading;
  var isSmallSize = ['xxxs', 'xxs', 'xs', 's'].includes(size);
  var sizes = isSmallSize ? _inline_edit_form.SMALL_SIZE_FORM : _inline_edit_form.MEDIUM_SIZE_FORM;
  var readModeProps = (0, _react.useMemo)(function () {
    if (!isReadOnly) return _readModeProps;
    var headingNumber = Number(heading.substring(1));
    return headingNumber ? _objectSpread(_objectSpread({}, _readModeProps), {}, {
      role: 'heading',
      'aria-level': headingNumber
    }) : _objectSpread(_objectSpread({}, _readModeProps), {}, {
      role: 'paragraph'
    });
  }, [_readModeProps, isReadOnly, heading]);
  return (0, _react2.jsx)(_inline_edit_form.EuiInlineEditForm, _extends({
    css: cssStyles,
    className: classes,
    readModeProps: readModeProps,
    isReadOnly: isReadOnly,
    sizes: sizes
  }, rest), function (titleReadModeValue) {
    return (0, _react2.jsx)(_title.EuiTitle, {
      size: size,
      className: "eui-textTruncate"
    }, (0, _react2.jsx)(H, {
      role: isReadOnly ? 'presentation' : undefined
    }, titleReadModeValue));
  });
};
EuiInlineEditTitle.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  placeholder: _propTypes.default.string,
  /**
       * Callback that fires when a user clicks the save button.
       * Passes the current edited text value as an argument.
       *
       * To validate the value of the edited text, pass back a boolean flag.
       * If `false`, EuiInlineEdit will remain in edit mode, where loading or invalid states can be set.
       * If `true`, EuiInlineEdit will return to read mode.
       */
  onSave: _propTypes.default.func,
  /**
       * Form label that appears above the form control.
       * This is required for accessibility because there is no visual label on the input.
       */
  inputAriaLabel: _propTypes.default.string.isRequired,
  /**
       * Starts the component in edit mode
       */
  startWithEditOpen: _propTypes.default.bool,
  /**
       * Props that will be applied directly to the `EuiEmptyButton` displayed in read mode
       */
  readModeProps: _propTypes.default.any,
  /**
       * Multiple props objects that can be applied directly to various child components displayed in edit mode.
       * - `formRowProps` will be passed to `EuiFormRow`
       * - `inputProps` will be passed to `EuiFieldText`
       * - `saveButtonProps` & `cancelButtonProps` will be passed to their respective `EuiButtonIcon`s
       */
  editModeProps: _propTypes.default.shape({
    formRowProps: _propTypes.default.any,
    inputProps: _propTypes.default.any,
    saveButtonProps: _propTypes.default.any,
    cancelButtonProps: _propTypes.default.any
  }),
  /**
       * Loading state - only displayed in edit mode
       */
  isLoading: _propTypes.default.bool,
  /**
       * Invalid state - only displayed edit mode
       */
  isInvalid: _propTypes.default.bool,
  /**
       * Locks inline edit in read mode and displays the text value
       */
  isReadOnly: _propTypes.default.bool,
  /**
         * Initial inline edit text value
         */
  defaultValue: _propTypes.default.string,
  /**
         * Callback required to reset `value` to the previous read mode text value.
         */
  onCancel: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.func.isRequired]),
  /**
         * To use inline edit as a controlled component, continuously pass the value via this prop
         */
  value: _propTypes.default.string,
  /**
         * Callback required to receive and update `value` based on user input
         */
  onChange: _propTypes.default.func,
  /**
     * Title size level
     */
  size: _propTypes.default.any,
  /**
     * Level of heading to be used for the title.
     * Use `span` for text that is not semantically a heading, but should still visually appear as a title.
     */
  heading: _propTypes.default.any.isRequired
};