"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiHeaderAlert = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _flex = require("../../flex");
var _services = require("../../../services");
var _header_alert = require("./header_alert.styles");
var _react2 = require("@emotion/react");
var _excluded = ["action", "className", "date", "text", "title", "badge"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiHeaderAlert = exports.EuiHeaderAlert = function EuiHeaderAlert(_ref) {
  var action = _ref.action,
    className = _ref.className,
    date = _ref.date,
    text = _ref.text,
    title = _ref.title,
    badge = _ref.badge,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_header_alert.euiHeaderAlertStyles);
  var classes = (0, _classnames.default)('euiHeaderAlert', className);
  var ariaId = (0, _services.useGeneratedHtmlId)();
  return (0, _react2.jsx)("article", _extends({
    "aria-labelledby": "".concat(ariaId, "-title"),
    className: classes,
    css: styles.euiHeaderAlert
  }, rest), (0, _react2.jsx)(_flex.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)("div", {
    className: "euiHeaderAlert__date",
    css: styles.euiHeaderAlert__date
  }, date)), badge && (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, badge)), (0, _react2.jsx)("h3", {
    id: "".concat(ariaId, "-title"),
    className: "euiHeaderAlert__title",
    css: styles.euiHeaderAlert__title
  }, title), (0, _react2.jsx)("div", {
    className: "euiHeaderAlert__text",
    css: styles.euiHeaderAlert__text
  }, text), action && (0, _react2.jsx)("div", {
    className: "euiHeaderAlert__action",
    css: styles.euiHeaderAlert__action
  }, action));
};
EuiHeaderAlert.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Adds a link to the alert.
       */
  action: _propTypes.default.node,
  date: _propTypes.default.node.isRequired,
  text: _propTypes.default.node,
  title: _propTypes.default.node.isRequired,
  /**
       * Accepts an `EuiBadge` that displays on the alert
       */
  badge: _propTypes.default.node
};