"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFieldPassword = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _i18n = require("../../i18n");
var _button = require("../../button");
var _form_control_layout = require("../form_control_layout");
var _validatable_control = require("../validatable_control");
var _eui_form_context = require("../eui_form_context");
var _field_password = require("./field_password.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "id", "name", "placeholder", "value", "disabled", "isInvalid", "fullWidth", "isLoading", "compressed", "inputRef", "prepend", "append", "type", "dualToggleProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiFieldPassword = exports.EuiFieldPassword = function EuiFieldPassword(props) {
  var _useFormContext = (0, _eui_form_context.useFormContext)(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var className = props.className,
    id = props.id,
    name = props.name,
    placeholder = props.placeholder,
    value = props.value,
    disabled = props.disabled,
    isInvalid = props.isInvalid,
    _props$fullWidth = props.fullWidth,
    fullWidth = _props$fullWidth === void 0 ? defaultFullWidth : _props$fullWidth,
    _props$isLoading = props.isLoading,
    isLoading = _props$isLoading === void 0 ? false : _props$isLoading,
    _props$compressed = props.compressed,
    compressed = _props$compressed === void 0 ? false : _props$compressed,
    _inputRef = props.inputRef,
    prepend = props.prepend,
    append = props.append,
    _props$type = props.type,
    type = _props$type === void 0 ? 'password' : _props$type,
    dualToggleProps = props.dualToggleProps,
    rest = _objectWithoutProperties(props, _excluded);

  // Set the initial input type to `password` if they want dual
  var _useState = (0, _react.useState)(type === 'dual' ? 'password' : type),
    _useState2 = _slicedToArray(_useState, 2),
    inputType = _useState2[0],
    setInputType = _useState2[1];

  // Setup toggle aria-label
  var _useEuiI18n = (0, _i18n.useEuiI18n)(['euiFieldPassword.showPassword', 'euiFieldPassword.maskPassword'], ['Show password as plain text. Note: this will visually expose your password on the screen.', 'Mask password']),
    _useEuiI18n2 = _slicedToArray(_useEuiI18n, 2),
    showPasswordLabel = _useEuiI18n2[0],
    maskPasswordLabel = _useEuiI18n2[1];

  // Setup the inputRef to auto-focus when toggling visibility
  var _useState3 = (0, _react.useState)(null),
    _useState4 = _slicedToArray(_useState3, 2),
    inputRef = _useState4[0],
    _setInputRef = _useState4[1];
  var setInputRef = (0, _services.useCombinedRefs)([_setInputRef, _inputRef]);
  var handleToggle = (0, _react.useCallback)(function (event, isVisible) {
    var _dualToggleProps$onCl;
    setInputType(isVisible ? 'password' : 'text');
    inputRef === null || inputRef === void 0 || inputRef.focus();
    dualToggleProps === null || dualToggleProps === void 0 || (_dualToggleProps$onCl = dualToggleProps.onClick) === null || _dualToggleProps$onCl === void 0 || _dualToggleProps$onCl.call(dualToggleProps, event);
  }, [inputRef, dualToggleProps]);

  // Add a toggling button to switch between `password` and `input` if consumer wants `dual`
  // https://www.w3schools.com/howto/howto_js_toggle_password.asp
  var visibilityToggle = (0, _react.useMemo)(function () {
    if (type === 'dual') {
      var isVisible = inputType === 'text';
      return (0, _react2.jsx)(_button.EuiButtonIcon, _extends({
        iconType: isVisible ? 'eyeClosed' : 'eye',
        "aria-label": isVisible ? maskPasswordLabel : showPasswordLabel,
        title: isVisible ? maskPasswordLabel : showPasswordLabel,
        disabled: disabled
      }, dualToggleProps, {
        onClick: function onClick(e) {
          return handleToggle(e, isVisible);
        }
      }));
    }
  }, [type, inputType, maskPasswordLabel, showPasswordLabel, dualToggleProps, handleToggle, disabled]);
  var finalAppend = (0, _react.useMemo)(function () {
    if (!visibilityToggle) return append;
    if (!append) return visibilityToggle;

    // Convert any `append` elements to an array so the visibility
    // toggle can be added to it
    var appendAsArray = append ? Array.isArray(append) ? append : [append] : [];
    return [].concat(_toConsumableArray(appendAsArray), [visibilityToggle]);
  }, [append, visibilityToggle]);
  var classes = (0, _classnames.default)('euiFieldPassword', {
    'euiFieldPassword-isLoading': isLoading
  }, className);
  var styles = (0, _services.useEuiMemoizedStyles)(_field_password.euiFieldPasswordStyles);
  var cssStyles = [styles.euiFieldPassword, compressed ? styles.compressed : styles.uncompressed, fullWidth ? styles.fullWidth : styles.formWidth, (finalAppend || prepend) && styles.inGroup, type === 'dual' && styles.withToggle];
  return (0, _react2.jsx)(_form_control_layout.EuiFormControlLayout, {
    icon: "lock",
    fullWidth: fullWidth,
    isLoading: isLoading,
    isInvalid: isInvalid,
    isDisabled: disabled,
    compressed: compressed,
    prepend: prepend,
    append: finalAppend
  }, (0, _react2.jsx)(_validatable_control.EuiValidatableControl, {
    isInvalid: isInvalid
  }, (0, _react2.jsx)("input", _extends({
    type: inputType,
    id: id,
    name: name,
    placeholder: placeholder,
    className: classes,
    css: cssStyles,
    value: value,
    disabled: disabled,
    ref: setInputRef
  }, rest))));
};
EuiFieldPassword.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  isInvalid: _propTypes.default.bool,
  /**
       * Expand to fill 100% of the parent.
       * Defaults to `fullWidth` prop of `<EuiForm>`.
       * @default false
       */
  fullWidth: _propTypes.default.bool,
  isLoading: _propTypes.default.bool,
  compressed: _propTypes.default.bool,
  inputRef: _propTypes.default.any,
  /**
       * Creates an input group with element(s) coming before input.
       * `string` | `ReactElement` or an array of these
       */
  prepend: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  /**
       * Creates an input group with element(s) coming after input.
       * `string` | `ReactElement` or an array of these
       */
  append: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]),
  /**
       * Change the `type` of input for manually handling obfuscation.
       * The `dual` option adds the ability to toggle the obfuscation of the input by
       * adding an icon button as the first `append` element
       * @default password
       */
  type: _propTypes.default.oneOf(["password", "text", "dual"]),
  /**
       * Additional props to apply to the dual toggle. Extends EuiButtonIcon
       */
  dualToggleProps: _propTypes.default.any
};