"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDescriptionListDescriptionStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _title = require("../title/title.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1yn9gig-inline",
  styles: "display:inline;label:inline;"
} : {
  name: "1yn9gig-inline",
  styles: "display:inline;label:inline;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiDescriptionListDescriptionStyles = exports.euiDescriptionListDescriptionStyles = function euiDescriptionListDescriptionStyles(euiThemeContext) {
  return {
    euiDescriptionList__description: /*#__PURE__*/(0, _react.css)(";label:euiDescriptionList__description;"),
    // Types
    row: /*#__PURE__*/(0, _react.css)(";label:row;"),
    column: /*#__PURE__*/(0, _react.css)(";label:column;"),
    inline: _ref,
    // This nested block handles just the font styling based on compressed and reverse
    fontStyles: {
      normal: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 's'), ";;label:normal;"),
      reverse: /*#__PURE__*/(0, _react.css)((0, _title.euiTitle)(euiThemeContext, 'xs'), ";;label:reverse;"),
      compressed: /*#__PURE__*/(0, _react.css)((0, _title.euiTitle)(euiThemeContext, 'xxs'), ";;label:compressed;")
    },
    // Nested inline styles for type and font
    inlineStyles: {
      compressed: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 'xs'), ";;label:compressed;"),
      normal: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 's'), ";;label:normal;")
    },
    // Column types should align description text to the left when EuiDecriptionList is centered
    left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalTextAlignCSS)('left'), ";;label:left;")
  };
};