"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridHeaderRow = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../../services");
var _data_grid_types = require("../../data_grid_types");
var _draggable_columns = require("./draggable_columns");
var _data_grid_control_header_cell = require("./data_grid_control_header_cell");
var _data_grid_header_cell = require("./data_grid_header_cell");
var _data_grid_header_row = require("./data_grid_header_row.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "data-test-subj", "leadingControlColumns", "trailingControlColumns", "columns", "columnWidths", "defaultColumnWidth", "setColumnWidth", "visibleColCount", "setVisibleColumns", "switchColumnPos", "sorting", "schema", "schemaDetectors", "gridStyles", "canDragAndDropColumns"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiDataGridHeaderRow = exports.EuiDataGridHeaderRow = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function (props, ref) {
  var _leadingControlColumn;
  var className = props.className,
    _dataTestSubj = props['data-test-subj'],
    _props$leadingControl = props.leadingControlColumns,
    leadingControlColumns = _props$leadingControl === void 0 ? _data_grid_types.emptyControlColumns : _props$leadingControl,
    _props$trailingContro = props.trailingControlColumns,
    trailingControlColumns = _props$trailingContro === void 0 ? _data_grid_types.emptyControlColumns : _props$trailingContro,
    columns = props.columns,
    columnWidths = props.columnWidths,
    defaultColumnWidth = props.defaultColumnWidth,
    setColumnWidth = props.setColumnWidth,
    visibleColCount = props.visibleColCount,
    setVisibleColumns = props.setVisibleColumns,
    switchColumnPos = props.switchColumnPos,
    sorting = props.sorting,
    schema = props.schema,
    schemaDetectors = props.schemaDetectors,
    gridStyles = props.gridStyles,
    canDragAndDropColumns = props.canDragAndDropColumns,
    rest = _objectWithoutProperties(props, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_data_grid_header_row.euiDataGridHeaderStyles);
  var cssStyles = [styles.euiDataGridHeader, styles[gridStyles.header]];
  var classes = (0, _classnames.default)('euiDataGridHeader', className);
  var dataTestSubj = (0, _classnames.default)('dataGridHeader', _dataTestSubj);
  var isLastColumn = (0, _react.useCallback)(function (index) {
    return index === visibleColCount - 1;
  }, [visibleColCount]);
  return (0, _react2.jsx)("div", _extends({
    role: "row",
    ref: ref,
    css: cssStyles,
    className: classes,
    "data-test-subj": dataTestSubj
  }, rest), leadingControlColumns.map(function (controlColumn, index) {
    return (0, _react2.jsx)(_data_grid_control_header_cell.EuiDataGridControlHeaderCell, {
      key: controlColumn.id,
      index: index,
      isLastColumn: isLastColumn(index),
      controlColumn: controlColumn
    });
  }), (0, _react2.jsx)(_draggable_columns.ConditionalDroppableColumns, {
    canDragAndDropColumns: !!canDragAndDropColumns,
    columns: columns,
    switchColumnPos: switchColumnPos,
    indexOffset: (_leadingControlColumn = leadingControlColumns === null || leadingControlColumns === void 0 ? void 0 : leadingControlColumns.length) !== null && _leadingControlColumn !== void 0 ? _leadingControlColumn : 0
  }, columns.map(function (column, index) {
    var visibleIndex = index + leadingControlColumns.length;
    return (0, _react2.jsx)(_data_grid_header_cell.EuiDataGridHeaderCell, {
      key: column.id,
      index: visibleIndex,
      isLastColumn: isLastColumn(visibleIndex),
      column: column,
      columns: columns,
      columnWidths: columnWidths,
      defaultColumnWidth: defaultColumnWidth,
      setColumnWidth: setColumnWidth,
      setVisibleColumns: setVisibleColumns,
      switchColumnPos: switchColumnPos,
      sorting: sorting,
      schema: schema,
      schemaDetectors: schemaDetectors,
      canDragAndDropColumns: canDragAndDropColumns,
      gridStyles: gridStyles
    });
  })), trailingControlColumns.map(function (controlColumn, index) {
    var visibleIndex = index + leadingControlColumns.length + columns.length;
    return (0, _react2.jsx)(_data_grid_control_header_cell.EuiDataGridControlHeaderCell, {
      key: controlColumn.id,
      index: visibleIndex,
      isLastColumn: isLastColumn(visibleIndex),
      controlColumn: controlColumn
    });
  }));
}));
EuiDataGridHeaderRow.displayName = 'EuiDataGridHeaderRow';