"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDataGridCellActionsStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../../global_styling");
var _high_contrast = require("../../../../global_styling/functions/high_contrast");
var _data_grid = require("../../data_grid.styles");
var _data_grid_cell = require("./data_grid_cell.styles");
var _templateObject;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _taggedTemplateLiteral(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
var euiDataGridCellActionsStyles = exports.euiDataGridCellActionsStyles = function euiDataGridCellActionsStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiDataGridVariables = (0, _data_grid.euiDataGridVariables)(euiThemeContext),
    levels = _euiDataGridVariables.levels;
  var borderWidth = euiTheme.border.width.thin;
  var cellOutline = (0, _data_grid_cell.euiDataGridCellOutlineStyles)(euiThemeContext);
  var _euiDataGridCellOutli = (0, _data_grid_cell.euiDataGridCellOutlineSelectors)('.euiDataGridRowCell'),
    cellSelectors = _euiDataGridCellOutli.actions;
  return {
    euiDataGridRowCell__actionsWrapper: /*#__PURE__*/(0, _react.css)("position:absolute;", (0, _global_styling.logicalCSS)('left', 0), " ", (0, _global_styling.logicalCSS)('bottom', '100%'), "z-index:", levels.stickyHeader - 1, ";.euiDataGridRowCell[data-gridcell-visible-row-index='0']>&{z-index:", levels.stickyHeader + 1, ";}", cellSelectors.hoverZone, " &{", (0, _global_styling.logicalCSS)('min-width', '50%'), " ", (0, _global_styling.logicalCSS)('padding-right', euiTheme.size.base), ";};label:euiDataGridRowCell__actionsWrapper;"),
    euiDataGridRowCell__actions: /*#__PURE__*/(0, _react.css)("position:relative;display:flex;gap:", euiTheme.size.xxs, ";", (0, _global_styling.logicalCSS)('width', 'fit-content'), " padding-inline:", euiTheme.size.xxs, ";", (0, _global_styling.logicalCSS)('margin-bottom', "-".concat(borderWidth)), " background-color:", cellOutline.focusColor, ";color:", euiTheme.colors.emptyShade, ";border:", borderWidth, " solid ", cellOutline.focusColor, ";border-radius:", cellOutline.borderRadius, ";", (0, _global_styling.logicalCSS)('border-bottom-left-radius', 0), "&::after{content:'';position:absolute;", (0, _global_styling.logicalCSS)('top', '100%'), " ", (0, _global_styling.logicalCSS)('left', "-".concat(borderWidth)), " ", (0, _global_styling.logicalSizeCSS)((0, _global_styling.mathWithUnits)(borderWidth, function (x) {
      return x * 2;
    })), " background-color:inherit;}", cellSelectors.hoverColor, " &{background-color:", cellOutline.hoverColor, ";border-color:", cellOutline.hoverColor, ";}", _global_styling.euiCanAnimate, "{transform:scaleY(0);transform-origin:bottom;", cellSelectors.showAnimation, " &{animation-duration:", euiTheme.animation.fast, ";animation-name:", slideUp, ";animation-iteration-count:1;animation-fill-mode:forwards;}", cellSelectors.hoverAnimation, " &{animation-delay:", euiTheme.animation.slow, ";}};label:euiDataGridRowCell__actions;"),
    euiDataGridRowCell__actionButtonIcon: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', euiTheme.size.base), " ", (0, _global_styling.logicalCSS)('height', (0, _global_styling.mathWithUnits)([euiTheme.size.base, euiTheme.size.xs], function (x, y) {
      return x + y;
    })), " border-radius:0;&,svg{background-color:transparent!important;color:currentColor!important;fill:currentColor!important;}", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      preferred: 'border: none;'
    }), ";;label:euiDataGridRowCell__actionButtonIcon;")
  };
};
var slideUp = (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  from { transform: scaleY(0); }\n  to { transform: scaleY(1); }\n"])));