"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeRatioByGroups = computeRatioByGroups;
exports.inplaceInsertInSortedArray = inplaceInsertInSortedArray;
const group_data_series_1 = require("../../chart_types/xy_chart/utils/group_data_series");
const common_1 = require("../common");
function computeRatioByGroups(data, groupAccessors, valueGetterSetters) {
    return (0, group_data_series_1.groupBy)(data, groupAccessors, true).flatMap((groupedData) => {
        const groupSum = groupedData.reduce((sum, datum) => {
            return (valueGetterSetters.reduce((valueSum, [getter]) => {
                const value = getter(datum);
                return valueSum + ((0, common_1.isFiniteNumber)(value) ? Math.abs(value) : 0);
            }, 0) + sum);
        }, 0);
        return groupedData.map((datum) => {
            return valueGetterSetters.reduce((acc, [getter, setter]) => {
                const value = getter(acc);
                return (0, common_1.isFiniteNumber)(value) ? setter(acc, groupSum === 0 ? 0 : Math.abs(value) / groupSum) : acc;
            }, datum);
        });
    });
}
function inplaceInsertInSortedArray(arr, obj, accessor) {
    let left = 0;
    let right = arr.length - 1;
    const value = accessor(obj);
    while (left <= right) {
        const mid = Math.floor((left + right) / 2);
        if (accessor(arr[mid]) < value) {
            left = mid + 1;
        }
        else {
            right = mid - 1;
        }
    }
    arr.splice(left, 0, obj);
    return arr;
}
//# sourceMappingURL=data_processing.js.map