"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnnotationAnimationTrigger = exports.AnnotationDomainType = exports.AnnotationType = exports.HistogramModeAlignments = exports.LabelOverflowConstraint = exports.DomainPaddingUnit = exports.Fit = exports.DEFAULT_GLOBAL_ID = exports.StackMode = exports.SeriesType = void 0;
exports.isLineAnnotation = isLineAnnotation;
exports.isRectAnnotation = isRectAnnotation;
exports.isBarSeriesSpec = isBarSeriesSpec;
exports.isBubbleSeriesSpec = isBubbleSeriesSpec;
exports.isLineSeriesSpec = isLineSeriesSpec;
exports.isAreaSeriesSpec = isAreaSeriesSpec;
exports.SeriesType = Object.freeze({
    Area: 'area',
    Bar: 'bar',
    Line: 'line',
    Bubble: 'bubble',
});
exports.StackMode = Object.freeze({
    Percentage: 'percentage',
    Wiggle: 'wiggle',
    Silhouette: 'silhouette',
});
exports.DEFAULT_GLOBAL_ID = '__global__';
exports.Fit = Object.freeze({
    None: 'none',
    Carry: 'carry',
    Lookahead: 'lookahead',
    Nearest: 'nearest',
    Average: 'average',
    Linear: 'linear',
    Zero: 'zero',
    Explicit: 'explicit',
});
exports.DomainPaddingUnit = Object.freeze({
    Domain: 'domain',
    Pixel: 'pixel',
    DomainRatio: 'domainRatio',
});
exports.LabelOverflowConstraint = Object.freeze({
    BarGeometry: 'barGeometry',
    ChartEdges: 'chartEdges',
});
exports.HistogramModeAlignments = Object.freeze({
    Start: 'start',
    Center: 'center',
    End: 'end',
});
exports.AnnotationType = Object.freeze({
    Line: 'line',
    Rectangle: 'rectangle',
    Text: 'text',
});
exports.AnnotationDomainType = Object.freeze({
    XDomain: 'xDomain',
    YDomain: 'yDomain',
});
exports.AnnotationAnimationTrigger = Object.freeze({
    FadeOnFocusingOthers: 'FadeOnFocusingOthers',
});
function isLineAnnotation(spec) {
    return spec.annotationType === exports.AnnotationType.Line;
}
function isRectAnnotation(spec) {
    return spec.annotationType === exports.AnnotationType.Rectangle;
}
function isBarSeriesSpec(spec) {
    return spec.seriesType === exports.SeriesType.Bar;
}
function isBubbleSeriesSpec(spec) {
    return spec.seriesType === exports.SeriesType.Bubble;
}
function isLineSeriesSpec(spec) {
    return spec.seriesType === exports.SeriesType.Line;
}
function isAreaSeriesSpec(spec) {
    return spec.seriesType === exports.SeriesType.Area;
}
//# sourceMappingURL=specs.js.map