"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.chartRenderer = void 0;
const react_1 = __importDefault(require("react"));
const brush_1 = require("../../../components/brush/brush");
const tooltip_1 = require("../../../components/tooltip/tooltip");
const xy_chart_1 = require("../renderer/canvas/xy_chart");
const annotations_1 = require("../renderer/dom/annotations");
const cursor_band_1 = require("../renderer/dom/cursor_band");
const cursor_crossline_1 = require("../renderer/dom/cursor_crossline");
const cursor_line_1 = require("../renderer/dom/cursor_line");
const highlighter_1 = require("../renderer/dom/highlighter");
const chartRenderer = (containerRef, forwardStageRef) => (react_1.default.createElement(react_1.default.Fragment, null,
    react_1.default.createElement(cursor_band_1.CursorBand, null),
    react_1.default.createElement(xy_chart_1.XYChart, { forwardCanvasRef: forwardStageRef }),
    react_1.default.createElement(cursor_line_1.CursorLine, null),
    react_1.default.createElement(cursor_crossline_1.CursorCrossLine, null),
    react_1.default.createElement(tooltip_1.Tooltip, { getChartContainerRef: containerRef }),
    react_1.default.createElement(annotations_1.Annotations, { getChartContainerRef: containerRef, chartAreaRef: forwardStageRef }),
    react_1.default.createElement(highlighter_1.Highlighter, null),
    react_1.default.createElement(brush_1.BrushTool, null)));
exports.chartRenderer = chartRenderer;
//# sourceMappingURL=chart_renderer.js.map