"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Metric = exports.MetricTrendShape = void 0;
exports.isBulletMetric = isBulletMetric;
exports.isMetricWNumberArrayValues = isMetricWNumberArrayValues;
exports.isMetricWStringArrayValues = isMetricWStringArrayValues;
exports.isMetricWNumber = isMetricWNumber;
exports.isMetricWText = isMetricWText;
exports.isMetricWProgress = isMetricWProgress;
exports.isMetricWTrend = isMetricWTrend;
const __1 = require("../..");
const spec_type_1 = require("../../../specs/spec_type");
const spec_factory_1 = require("../../../state/spec_factory");
exports.MetricTrendShape = Object.freeze({
    Bars: 'bars',
    Area: 'area',
});
exports.Metric = (0, spec_factory_1.specComponentFactory)()({
    chartType: __1.ChartType.Metric,
    specType: spec_type_1.SpecType.Series,
}, {
    data: [],
});
function isBulletMetric(datum) {
    return Array.isArray(datum.domain);
}
function isMetricWNumberArrayValues(datum) {
    return Array.isArray(datum.value) && typeof datum.value[0] === 'number' && datum.hasOwnProperty('valueFormatter');
}
function isMetricWStringArrayValues(datum) {
    return Array.isArray(datum.value) && typeof datum.value[0] === 'string';
}
function isMetricWNumber(datum) {
    return 'value' in datum && typeof datum.value === 'number' && datum.hasOwnProperty('valueFormatter');
}
function isMetricWText(datum) {
    return 'value' in datum && typeof datum.value === 'string';
}
function isMetricWProgress(datum) {
    return ((isMetricWNumber(datum) && datum.hasOwnProperty('domainMax') && !datum.hasOwnProperty('trend')) ||
        isBulletMetric(datum));
}
function isMetricWTrend(datum) {
    return ((isMetricWNumber(datum) ||
        isMetricWText(datum) ||
        isMetricWNumberArrayValues(datum) ||
        isMetricWStringArrayValues(datum)) &&
        datum.hasOwnProperty('trend') &&
        !datum.hasOwnProperty('domainMax'));
}
//# sourceMappingURL=index.js.map