"use strict";
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __reExport = (target, mod, secondTarget) => (__copyProps(target, mod, "default"), secondTarget && __copyProps(secondTarget, mod, "default"));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};

// src/index.ts
var index_exports = {};
__export(index_exports, {
  AsyncLocalStorageTransactionContextPropagator: () => AsyncLocalStorageTransactionContextPropagator,
  InMemoryProvider: () => InMemoryProvider,
  NOOP_PROVIDER: () => NOOP_PROVIDER,
  NOOP_TRANSACTION_CONTEXT_PROPAGATOR: () => NOOP_TRANSACTION_CONTEXT_PROPAGATOR,
  OpenFeature: () => OpenFeature,
  OpenFeatureAPI: () => OpenFeatureAPI,
  OpenFeatureEventEmitter: () => OpenFeatureEventEmitter,
  ProviderEvents: () => import_core6.ServerProviderEvents,
  ProviderStatus: () => import_core.ServerProviderStatus
});
module.exports = __toCommonJS(index_exports);

// src/provider/provider.ts
var import_core = require("@openfeature/core");

// src/provider/no-op-provider.ts
var REASON_NO_OP = "No-op";
var NoopFeatureProvider = class {
  constructor() {
    this.metadata = {
      name: "No-op Provider"
    };
  }
  resolveBooleanEvaluation(_, defaultValue) {
    return this.noOp(defaultValue);
  }
  resolveStringEvaluation(_, defaultValue) {
    return this.noOp(defaultValue);
  }
  resolveNumberEvaluation(_, defaultValue) {
    return this.noOp(defaultValue);
  }
  resolveObjectEvaluation(_, defaultValue) {
    return this.noOp(defaultValue);
  }
  noOp(defaultValue) {
    return Promise.resolve({
      value: defaultValue,
      reason: REASON_NO_OP
    });
  }
};
var NOOP_PROVIDER = new NoopFeatureProvider();

// src/provider/in-memory-provider/in-memory-provider.ts
var import_core3 = require("@openfeature/core");

// src/provider/in-memory-provider/variant-not-found-error.ts
var import_core2 = require("@openfeature/core");
var VariantFoundError = class _VariantFoundError extends import_core2.OpenFeatureError {
  constructor(message) {
    super(message);
    Object.setPrototypeOf(this, _VariantFoundError.prototype);
    this.name = "VariantFoundError";
    this.code = import_core2.ErrorCode.GENERAL;
  }
};

// src/provider/in-memory-provider/in-memory-provider.ts
var InMemoryProvider = class {
  constructor(flagConfiguration = {}) {
    this.events = new OpenFeatureEventEmitter();
    this.runsOn = "server";
    this.metadata = {
      name: "in-memory"
    };
    this._flagConfiguration = __spreadValues({}, flagConfiguration);
  }
  /**
   * Overwrites the configured flags.
   * @param { FlagConfiguration } flagConfiguration new flag configuration
   */
  putConfiguration(flagConfiguration) {
    const flagsChanged = Object.entries(flagConfiguration).filter(([key, value]) => this._flagConfiguration[key] !== value).map(([key]) => key);
    this._flagConfiguration = __spreadValues({}, flagConfiguration);
    this.events.emit(import_core6.ServerProviderEvents.ConfigurationChanged, { flagsChanged });
  }
  resolveBooleanEvaluation(flagKey, defaultValue, context, logger) {
    return this.resolveFlagWithReason(flagKey, defaultValue, context, logger);
  }
  resolveNumberEvaluation(flagKey, defaultValue, context, logger) {
    return this.resolveFlagWithReason(flagKey, defaultValue, context, logger);
  }
  resolveStringEvaluation(flagKey, defaultValue, context, logger) {
    return __async(this, null, function* () {
      return this.resolveFlagWithReason(flagKey, defaultValue, context, logger);
    });
  }
  resolveObjectEvaluation(flagKey, defaultValue, context, logger) {
    return __async(this, null, function* () {
      return this.resolveFlagWithReason(flagKey, defaultValue, context, logger);
    });
  }
  resolveFlagWithReason(flagKey, defaultValue, ctx, logger) {
    return __async(this, null, function* () {
      try {
        const resolutionResult = this.lookupFlagValue(flagKey, defaultValue, ctx, logger);
        if (typeof (resolutionResult == null ? void 0 : resolutionResult.value) != typeof defaultValue) {
          throw new import_core3.TypeMismatchError();
        }
        return resolutionResult;
      } catch (error) {
        if (!(error instanceof import_core3.OpenFeatureError)) {
          throw new import_core3.GeneralError((error == null ? void 0 : error.message) || "unknown error");
        }
        throw error;
      }
    });
  }
  lookupFlagValue(flagKey, defaultValue, ctx, logger) {
    var _a;
    if (!(flagKey in this._flagConfiguration)) {
      const message = `no flag found with key ${flagKey}`;
      logger == null ? void 0 : logger.debug(message);
      throw new import_core3.FlagNotFoundError(message);
    }
    const flagSpec = this._flagConfiguration[flagKey];
    if (flagSpec.disabled) {
      return { value: defaultValue, reason: import_core3.StandardResolutionReasons.DISABLED };
    }
    const isContextEval = ctx && (flagSpec == null ? void 0 : flagSpec.contextEvaluator);
    const variant = isContextEval ? (_a = flagSpec.contextEvaluator) == null ? void 0 : _a.call(flagSpec, ctx) : flagSpec.defaultVariant;
    const value = variant && (flagSpec == null ? void 0 : flagSpec.variants[variant]);
    if (value === void 0) {
      const message = `no value associated with variant ${variant}`;
      logger == null ? void 0 : logger.error(message);
      throw new VariantFoundError(message);
    }
    return __spreadProps(__spreadValues({
      value
    }, variant && { variant }), {
      reason: isContextEval ? import_core3.StandardResolutionReasons.TARGETING_MATCH : import_core3.StandardResolutionReasons.STATIC
    });
  }
};

// src/open-feature.ts
var import_core7 = require("@openfeature/core");

// src/client/internal/open-feature-client.ts
var import_core4 = require("@openfeature/core");
var OpenFeatureClient = class {
  constructor(providerAccessor, providerStatusAccessor, emitterAccessor, apiContextAccessor, apiHooksAccessor, transactionContextAccessor, globalLogger, options, context = {}) {
    this.providerAccessor = providerAccessor;
    this.providerStatusAccessor = providerStatusAccessor;
    this.emitterAccessor = emitterAccessor;
    this.apiContextAccessor = apiContextAccessor;
    this.apiHooksAccessor = apiHooksAccessor;
    this.transactionContextAccessor = transactionContextAccessor;
    this.globalLogger = globalLogger;
    this.options = options;
    this._hooks = [];
    this._context = context;
  }
  get metadata() {
    var _a, _b;
    return {
      // Use domain if name is not provided
      name: (_a = this.options.domain) != null ? _a : this.options.name,
      domain: (_b = this.options.domain) != null ? _b : this.options.name,
      version: this.options.version,
      providerMetadata: this.providerAccessor().metadata
    };
  }
  get providerStatus() {
    return this.providerStatusAccessor();
  }
  addHandler(eventType, handler, options) {
    var _a;
    this.emitterAccessor().addHandler(eventType, handler);
    const shouldRunNow = (0, import_core4.statusMatchesEvent)(eventType, this._providerStatus);
    if (shouldRunNow) {
      try {
        handler({
          clientName: this.metadata.name,
          domain: this.metadata.domain,
          providerName: this._provider.metadata.name
        });
      } catch (err) {
        (_a = this._logger) == null ? void 0 : _a.error("Error running event handler:", err);
      }
    }
    if ((options == null ? void 0 : options.signal) && typeof options.signal.addEventListener === "function") {
      options.signal.addEventListener("abort", () => {
        this.removeHandler(eventType, handler);
      });
    }
  }
  removeHandler(eventType, handler) {
    this.emitterAccessor().removeHandler(eventType, handler);
  }
  getHandlers(eventType) {
    return this.emitterAccessor().getHandlers(eventType);
  }
  setLogger(logger) {
    this._clientLogger = new import_core4.SafeLogger(logger);
    return this;
  }
  setContext(context) {
    this._context = context;
    return this;
  }
  getContext() {
    return this._context;
  }
  addHooks(...hooks) {
    this._hooks = [...this._hooks, ...hooks];
    return this;
  }
  getHooks() {
    return this._hooks;
  }
  clearHooks() {
    this._hooks = [];
    return this;
  }
  getBooleanValue(flagKey, defaultValue, context, options) {
    return __async(this, null, function* () {
      return (yield this.getBooleanDetails(flagKey, defaultValue, context, options)).value;
    });
  }
  getBooleanDetails(flagKey, defaultValue, context, options) {
    return this.evaluate(
      flagKey,
      this._provider.resolveBooleanEvaluation,
      defaultValue,
      "boolean",
      context,
      options
    );
  }
  getStringValue(flagKey, defaultValue, context, options) {
    return __async(this, null, function* () {
      return (yield this.getStringDetails(flagKey, defaultValue, context, options)).value;
    });
  }
  getStringDetails(flagKey, defaultValue, context, options) {
    return this.evaluate(
      flagKey,
      // this isolates providers from our restricted string generic argument.
      this._provider.resolveStringEvaluation,
      defaultValue,
      "string",
      context,
      options
    );
  }
  getNumberValue(flagKey, defaultValue, context, options) {
    return __async(this, null, function* () {
      return (yield this.getNumberDetails(flagKey, defaultValue, context, options)).value;
    });
  }
  getNumberDetails(flagKey, defaultValue, context, options) {
    return this.evaluate(
      flagKey,
      // this isolates providers from our restricted number generic argument.
      this._provider.resolveNumberEvaluation,
      defaultValue,
      "number",
      context,
      options
    );
  }
  getObjectValue(flagKey, defaultValue, context, options) {
    return __async(this, null, function* () {
      return (yield this.getObjectDetails(flagKey, defaultValue, context, options)).value;
    });
  }
  getObjectDetails(flagKey, defaultValue, context, options) {
    return this.evaluate(flagKey, this._provider.resolveObjectEvaluation, defaultValue, "object", context, options);
  }
  track(occurrenceKey, context = {}, occurrenceDetails = {}) {
    var _a, _b;
    try {
      this.shortCircuitIfNotReady();
      if (typeof this._provider.track === "function") {
        const frozenContext = Object.freeze(this.mergeContexts(context));
        return (_b = (_a = this._provider).track) == null ? void 0 : _b.call(_a, occurrenceKey, frozenContext, occurrenceDetails);
      } else {
        this._logger.debug("Provider does not support the track function; will no-op.");
      }
    } catch (err) {
      this._logger.debug("Error recording tracking event.", err);
    }
  }
  evaluate(_0, _1, _2, _3) {
    return __async(this, arguments, function* (flagKey, resolver, defaultValue, flagType, invocationContext = {}, options = {}) {
      var _a;
      const allHooks = [
        ...this.apiHooksAccessor(),
        ...this.getHooks(),
        ...options.hooks || [],
        ...this._provider.hooks || []
      ];
      const allHooksReversed = [...allHooks].reverse();
      const mergedContext = this.mergeContexts(invocationContext);
      const hookContext = {
        flagKey,
        defaultValue,
        flagValueType: flagType,
        clientMetadata: this.metadata,
        providerMetadata: this._provider.metadata,
        context: mergedContext,
        logger: this._logger
      };
      let evaluationDetails;
      try {
        const frozenContext = yield this.beforeHooks(allHooks, hookContext, options);
        this.shortCircuitIfNotReady();
        const resolution = yield resolver.call(this._provider, flagKey, defaultValue, frozenContext, this._logger);
        const resolutionDetails = __spreadProps(__spreadValues({}, resolution), {
          flagMetadata: Object.freeze((_a = resolution.flagMetadata) != null ? _a : {}),
          flagKey
        });
        if (resolutionDetails.errorCode) {
          const err = (0, import_core4.instantiateErrorByErrorCode)(resolutionDetails.errorCode, resolutionDetails.errorMessage);
          yield this.errorHooks(allHooksReversed, hookContext, err, options);
          evaluationDetails = this.getErrorEvaluationDetails(flagKey, defaultValue, err, resolutionDetails.flagMetadata);
        } else {
          yield this.afterHooks(allHooksReversed, hookContext, resolutionDetails, options);
          evaluationDetails = resolutionDetails;
        }
      } catch (err) {
        yield this.errorHooks(allHooksReversed, hookContext, err, options);
        evaluationDetails = this.getErrorEvaluationDetails(flagKey, defaultValue, err);
      }
      yield this.finallyHooks(allHooksReversed, hookContext, evaluationDetails, options);
      return evaluationDetails;
    });
  }
  beforeHooks(hooks, hookContext, options) {
    return __async(this, null, function* () {
      var _a;
      for (const hook of hooks) {
        Object.freeze(hookContext);
        Object.assign(hookContext.context, __spreadValues(__spreadValues({}, hookContext.context), yield (_a = hook == null ? void 0 : hook.before) == null ? void 0 : _a.call(hook, hookContext, Object.freeze(options.hookHints))));
      }
      return Object.freeze(hookContext.context);
    });
  }
  afterHooks(hooks, hookContext, evaluationDetails, options) {
    return __async(this, null, function* () {
      var _a;
      for (const hook of hooks) {
        yield (_a = hook == null ? void 0 : hook.after) == null ? void 0 : _a.call(hook, hookContext, evaluationDetails, options.hookHints);
      }
    });
  }
  errorHooks(hooks, hookContext, err, options) {
    return __async(this, null, function* () {
      var _a;
      for (const hook of hooks) {
        try {
          yield (_a = hook == null ? void 0 : hook.error) == null ? void 0 : _a.call(hook, hookContext, err, options.hookHints);
        } catch (err2) {
          this._logger.error(`Unhandled error during 'error' hook: ${err2}`);
          if (err2 instanceof Error) {
            this._logger.error(err2.stack);
          }
          this._logger.error(err2 == null ? void 0 : err2.stack);
        }
      }
    });
  }
  finallyHooks(hooks, hookContext, evaluationDetails, options) {
    return __async(this, null, function* () {
      var _a;
      for (const hook of hooks) {
        try {
          yield (_a = hook == null ? void 0 : hook.finally) == null ? void 0 : _a.call(hook, hookContext, evaluationDetails, options.hookHints);
        } catch (err) {
          this._logger.error(`Unhandled error during 'finally' hook: ${err}`);
          if (err instanceof Error) {
            this._logger.error(err.stack);
          }
          this._logger.error(err == null ? void 0 : err.stack);
        }
      }
    });
  }
  get _provider() {
    return this.providerAccessor();
  }
  get _providerStatus() {
    return this.providerStatusAccessor();
  }
  get _logger() {
    return this._clientLogger || this.globalLogger();
  }
  mergeContexts(invocationContext) {
    return __spreadValues(__spreadValues(__spreadValues(__spreadValues({}, this.apiContextAccessor()), this.transactionContextAccessor()), this._context), invocationContext);
  }
  shortCircuitIfNotReady() {
    if (this.providerStatus === import_core.ServerProviderStatus.NOT_READY) {
      throw new import_core4.ProviderNotReadyError("provider has not yet initialized");
    } else if (this.providerStatus === import_core.ServerProviderStatus.FATAL) {
      throw new import_core4.ProviderFatalError("provider is in an irrecoverable error state");
    }
  }
  getErrorEvaluationDetails(flagKey, defaultValue, err, flagMetadata = {}) {
    const errorMessage = err == null ? void 0 : err.message;
    const errorCode = (err == null ? void 0 : err.code) || import_core4.ErrorCode.GENERAL;
    return {
      errorCode,
      errorMessage,
      value: defaultValue,
      reason: import_core4.StandardResolutionReasons.ERROR,
      flagMetadata: Object.freeze(flagMetadata),
      flagKey
    };
  }
};

// src/events/open-feature-event-emitter.ts
var import_core5 = require("@openfeature/core");
var import_node_events = require("node:events");
var OpenFeatureEventEmitter = class extends import_core5.GenericEventEmitter {
  constructor() {
    super();
    this.eventEmitter = new import_node_events.EventEmitter({ captureRejections: true });
    this.eventEmitter.on("error", (err) => {
      var _a;
      (_a = this._logger) == null ? void 0 : _a.error("Error running event handler:", err);
    });
  }
};

// src/events/events.ts
var import_core6 = require("@openfeature/core");

// src/transaction-context/no-op-transaction-context-propagator.ts
var NoopTransactionContextPropagator = class {
  getTransactionContext() {
    return {};
  }
  setTransactionContext(_, callback, ...args) {
    callback(...args);
  }
};
var NOOP_TRANSACTION_CONTEXT_PROPAGATOR = new NoopTransactionContextPropagator();

// src/transaction-context/async-local-storage-transaction-context-propagator.ts
var import_async_hooks = require("async_hooks");
var AsyncLocalStorageTransactionContextPropagator = class {
  constructor() {
    this.asyncLocalStorage = new import_async_hooks.AsyncLocalStorage();
  }
  getTransactionContext() {
    var _a;
    return (_a = this.asyncLocalStorage.getStore()) != null ? _a : {};
  }
  setTransactionContext(transactionContext, callback, ...args) {
    this.asyncLocalStorage.run(transactionContext, callback, ...args);
  }
};

// src/open-feature.ts
var GLOBAL_OPENFEATURE_API_KEY = Symbol.for("@openfeature/js-sdk/api");
var _globalThis = globalThis;
var OpenFeatureAPI = class _OpenFeatureAPI extends import_core7.OpenFeatureCommonAPI {
  constructor() {
    super("server");
    this._statusEnumType = import_core.ServerProviderStatus;
    this._apiEmitter = new OpenFeatureEventEmitter();
    this._defaultProvider = new import_core7.ProviderWrapper(
      NOOP_PROVIDER,
      import_core.ServerProviderStatus.NOT_READY,
      this._statusEnumType
    );
    this._domainScopedProviders = /* @__PURE__ */ new Map();
    this._createEventEmitter = () => new OpenFeatureEventEmitter();
    this._transactionContextPropagator = NOOP_TRANSACTION_CONTEXT_PROPAGATOR;
  }
  /**
   * Gets a singleton instance of the OpenFeature API.
   * @ignore
   * @returns {OpenFeatureAPI} OpenFeature API
   */
  static getInstance() {
    const globalApi = _globalThis[GLOBAL_OPENFEATURE_API_KEY];
    if (globalApi) {
      return globalApi;
    }
    const instance = new _OpenFeatureAPI();
    _globalThis[GLOBAL_OPENFEATURE_API_KEY] = instance;
    return instance;
  }
  getProviderStatus(domain) {
    var _a, _b;
    if (!domain) {
      return this._defaultProvider.status;
    }
    return (_b = (_a = this._domainScopedProviders.get(domain)) == null ? void 0 : _a.status) != null ? _b : this._defaultProvider.status;
  }
  setProviderAndWait(domainOrProvider, providerOrUndefined) {
    return __async(this, null, function* () {
      const domain = (0, import_core7.stringOrUndefined)(domainOrProvider);
      const provider = domain ? (0, import_core7.objectOrUndefined)(providerOrUndefined) : (0, import_core7.objectOrUndefined)(domainOrProvider);
      yield this.setAwaitableProvider(domain, provider);
    });
  }
  setProvider(clientOrProvider, providerOrUndefined) {
    const domain = (0, import_core7.stringOrUndefined)(clientOrProvider);
    const provider = domain ? (0, import_core7.objectOrUndefined)(providerOrUndefined) : (0, import_core7.objectOrUndefined)(clientOrProvider);
    const maybePromise = this.setAwaitableProvider(domain, provider);
    Promise.resolve(maybePromise).catch((err) => {
      this._logger.error("Error during provider initialization:", err);
    });
    return this;
  }
  getProvider(domain) {
    return this.getProviderForClient(domain);
  }
  setContext(context) {
    this._context = context;
    return this;
  }
  getContext() {
    return this._context;
  }
  getClient(domainOrContext, versionOrContext, contextOrUndefined) {
    var _a, _b;
    const domain = (0, import_core7.stringOrUndefined)(domainOrContext);
    const version = (0, import_core7.stringOrUndefined)(versionOrContext);
    const context = (_b = (_a = (0, import_core7.objectOrUndefined)(domainOrContext)) != null ? _a : (0, import_core7.objectOrUndefined)(versionOrContext)) != null ? _b : (0, import_core7.objectOrUndefined)(contextOrUndefined);
    return new OpenFeatureClient(
      () => this.getProviderForClient(domain),
      () => this.getProviderStatus(domain),
      () => this.buildAndCacheEventEmitterForClient(domain),
      () => this.getContext(),
      () => this.getHooks(),
      () => this.getTransactionContext(),
      () => this._logger,
      { domain, version },
      context
    );
  }
  /**
   * Clears all registered providers and resets the default provider.
   * @returns {Promise<void>}
   */
  clearProviders() {
    return super.clearProvidersAndSetDefault(NOOP_PROVIDER);
  }
  setTransactionContextPropagator(transactionContextPropagator) {
    const baseMessage = "Invalid TransactionContextPropagator, will not be set: ";
    if (typeof (transactionContextPropagator == null ? void 0 : transactionContextPropagator.getTransactionContext) !== "function") {
      this._logger.error(`${baseMessage}: getTransactionContext is not a function.`);
    } else if (typeof (transactionContextPropagator == null ? void 0 : transactionContextPropagator.setTransactionContext) !== "function") {
      this._logger.error(`${baseMessage}: setTransactionContext is not a function.`);
    } else {
      this._transactionContextPropagator = transactionContextPropagator;
    }
    return this;
  }
  setTransactionContext(transactionContext, callback, ...args) {
    this._transactionContextPropagator.setTransactionContext(transactionContext, callback, ...args);
  }
  getTransactionContext() {
    try {
      return this._transactionContextPropagator.getTransactionContext();
    } catch (err) {
      const error = err;
      this._logger.error(`Error getting transaction context: ${error == null ? void 0 : error.message}, returning empty context.`);
      this._logger.error(error == null ? void 0 : error.stack);
      return {};
    }
  }
};
var OpenFeature = OpenFeatureAPI.getInstance();

// src/index.ts
__reExport(index_exports, require("@openfeature/core"), module.exports);
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AsyncLocalStorageTransactionContextPropagator,
  InMemoryProvider,
  NOOP_PROVIDER,
  NOOP_TRANSACTION_CONTEXT_PROPAGATOR,
  OpenFeature,
  OpenFeatureAPI,
  OpenFeatureEventEmitter,
  ProviderEvents,
  ProviderStatus,
  ...require("@openfeature/core")
});
//# sourceMappingURL=index.js.map
