"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Translate {@link TrackingEventDetails} to an object suitable for use as the data
 * parameter in LDClient.track().
 * @param details The {@link TrackingEventDetails} to translate.
 * @returns An object suitable use as the data parameter in LDClient.track().
 * The value attribute will be removed and if the resulting object is empty,
 * returns undefined.
 *
 * @internal
 */
function translateTrackingEventDetails(details) {
    const { value, ...data } = details;
    return Object.keys(data).length ? data : undefined;
}
exports.default = translateTrackingEventDetails;
//# sourceMappingURL=translateTrackingEventDetails.js.map