"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable class-methods-use-this */
const os = require("os");
const packageJson = require("../../package.json");
function processPlatformName(name) {
    switch (name) {
        case 'darwin':
            return 'MacOS';
        case 'win32':
            return 'Windows';
        case 'linux':
            return 'Linux';
        default:
            return name;
    }
}
class NodeInfo {
    constructor(_config) {
        this._config = _config;
    }
    platformData() {
        return {
            os: {
                name: processPlatformName(os.platform()),
                version: os.version(),
                arch: os.arch(),
            },
            name: 'Node',
            additional: {
                nodeVersion: process.versions.node,
            },
        };
    }
    sdkData() {
        return {
            name: packageJson.name,
            version: packageJson.version,
            userAgentBase: 'NodeJSClient',
            wrapperName: this._config.wrapperName,
            wrapperVersion: this._config.wrapperVersion,
        };
    }
}
exports.default = NodeInfo;
//# sourceMappingURL=NodeInfo.js.map