"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Emits = void 0;
/**
 * Adds the implementation of an event emitter to something that contains
 * a field of `emitter` with type `EventEmitter`.
 * @param Base The class to derive the mixin from.
 * @returns A class extending the base with an event emitter.
 */
function Emits(Base) {
    return class WithEvents extends Base {
        on(eventName, listener) {
            this.emitter.on(eventName, listener);
            return this;
        }
        addListener(eventName, listener) {
            this.emitter.addListener(eventName, listener);
            return this;
        }
        once(eventName, listener) {
            this.emitter.once(eventName, listener);
            return this;
        }
        removeListener(eventName, listener) {
            this.emitter.removeListener(eventName, listener);
            return this;
        }
        off(eventName, listener) {
            this.emitter.off(eventName, listener);
            return this;
        }
        removeAllListeners(event) {
            this.emitter.removeAllListeners(event);
            return this;
        }
        setMaxListeners(n) {
            this.emitter.setMaxListeners(n);
            return this;
        }
        getMaxListeners() {
            return this.emitter.getMaxListeners();
        }
        listeners(eventName) {
            return this.emitter.listeners(eventName);
        }
        rawListeners(eventName) {
            return this.emitter.rawListeners(eventName);
        }
        emit(eventName, ...args) {
            return this.emitter.emit(eventName, args);
        }
        listenerCount(eventName) {
            return this.emitter.listenerCount(eventName);
        }
        prependListener(eventName, listener) {
            this.emitter.prependListener(eventName, listener);
            return this;
        }
        prependOnceListener(eventName, listener) {
            this.emitter.prependOnceListener(eventName, listener);
            return this;
        }
        eventNames() {
            return this.emitter.eventNames();
        }
    };
}
exports.Emits = Emits;
//# sourceMappingURL=Emits.js.map