"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.persistentStoreKinds = void 0;
const serialization_1 = require("./serialization");
const VersionedDataKinds_1 = require("./VersionedDataKinds");
/**
 * Map namespace to a persistent store kind.
 */
exports.persistentStoreKinds = {
    segments: {
        namespace: VersionedDataKinds_1.default.Segments.namespace,
        deserialize: (data) => {
            const segment = (0, serialization_1.deserializeSegment)(data);
            if (segment) {
                return {
                    version: segment.version,
                    item: segment,
                };
            }
            return undefined;
        },
        serialize: (data) => {
            const serializedItem = (0, serialization_1.serializeSegment)(data);
            return {
                version: data.version,
                deleted: data.deleted,
                serializedItem,
            };
        },
        priority: 0,
    },
    features: {
        namespace: VersionedDataKinds_1.default.Features.namespace,
        deserialize: (data) => {
            const flag = (0, serialization_1.deserializeFlag)(data);
            if (flag) {
                return {
                    version: flag.version,
                    item: flag,
                };
            }
            return undefined;
        },
        serialize: (data) => {
            const serializedItem = (0, serialization_1.serializeFlag)(data);
            return {
                version: data.version,
                deleted: data.deleted,
                serializedItem,
            };
        },
        priority: 1,
    },
};
//# sourceMappingURL=persistentStoreKinds.js.map