"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const promisify_1 = require("../async/promisify");
/**
 * Provides an async interface to a feature store.
 *
 * This allows for using a store using async/await instead of callbacks.
 *
 */
class AsyncTransactionalStoreFacade {
    constructor(store) {
        this._store = store;
    }
    async get(kind, key) {
        return (0, promisify_1.default)((cb) => {
            this._store.get(kind, key, cb);
        });
    }
    async all(kind) {
        return (0, promisify_1.default)((cb) => {
            this._store.all(kind, cb);
        });
    }
    async init(allData, initMetadata) {
        return (0, promisify_1.default)((cb) => {
            this._store.init(allData, cb, initMetadata);
        });
    }
    async delete(kind, key, version) {
        return (0, promisify_1.default)((cb) => {
            this._store.delete(kind, key, version, cb);
        });
    }
    async upsert(kind, data) {
        return (0, promisify_1.default)((cb) => {
            this._store.upsert(kind, data, cb);
        });
    }
    async initialized() {
        return (0, promisify_1.default)((cb) => {
            this._store.initialized(cb);
        });
    }
    async applyChanges(basis, data, initMetadata, selector) {
        return (0, promisify_1.default)((cb) => {
            this._store.applyChanges(basis, data, cb, initMetadata, selector);
        });
    }
    close() {
        this._store.close();
    }
    getInitMetadata() {
        var _a, _b;
        return (_b = (_a = this._store).getInitMetaData) === null || _b === void 0 ? void 0 : _b.call(_a);
    }
}
exports.default = AsyncTransactionalStoreFacade;
//# sourceMappingURL=AsyncTransactionalStoreFacade.js.map