"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @internal
 */
class TestDataSource {
    constructor(_featureStore, initialFlags, initialSegments, _onStop, _listeners) {
        this._featureStore = _featureStore;
        this._onStop = _onStop;
        this._listeners = _listeners;
        // make copies of these objects to decouple them from the originals
        // so updates made to the originals don't affect these internal data.
        this._flags = Object.assign({}, initialFlags);
        this._segments = Object.assign({}, initialSegments);
    }
    async start() {
        this._listeners.forEach(({ processJson }) => {
            const dataJson = { data: { flags: this._flags, segments: this._segments } };
            processJson(dataJson);
        });
    }
    stop() {
        this._onStop(this);
    }
    close() {
        this.stop();
    }
    async upsert(kind, value) {
        return this._featureStore.upsert(kind, value);
    }
}
exports.default = TestDataSource;
//# sourceMappingURL=TestDataSource.js.map