"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const js_sdk_common_1 = require("@launchdarkly/js-sdk-common");
const api_1 = require("../api");
const Configuration_1 = require("../options/Configuration");
const createDiagnosticsInitConfig = (config, platform, featureStore) => {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
    let pollingIntervalMillis;
    if ((_a = config.dataSystem) === null || _a === void 0 ? void 0 : _a.dataSource) {
        if (((0, api_1.isStandardOptions)(config.dataSystem.dataSource) ||
            (0, api_1.isPollingOnlyOptions)(config.dataSystem.dataSource)) &&
            config.dataSystem.dataSource.pollInterval) {
            pollingIntervalMillis = (0, js_sdk_common_1.secondsToMillis)(config.dataSystem.dataSource.pollInterval);
        }
    }
    else {
        pollingIntervalMillis = (0, js_sdk_common_1.secondsToMillis)(config.pollInterval);
    }
    let reconnectTimeMillis;
    if ((_b = config.dataSystem) === null || _b === void 0 ? void 0 : _b.dataSource) {
        if (((0, api_1.isStandardOptions)(config.dataSystem.dataSource) ||
            (0, api_1.isStreamingOnlyOptions)(config.dataSystem.dataSource)) &&
            config.dataSystem.dataSource.streamInitialReconnectDelay) {
            reconnectTimeMillis = (0, js_sdk_common_1.secondsToMillis)(config.dataSystem.dataSource.streamInitialReconnectDelay);
        }
    }
    else {
        reconnectTimeMillis = (0, js_sdk_common_1.secondsToMillis)(config.streamInitialReconnectDelay);
    }
    let streamDisabled;
    if ((_c = config.dataSystem) === null || _c === void 0 ? void 0 : _c.dataSource) {
        streamDisabled = (0, api_1.isPollingOnlyOptions)((_d = config.dataSystem) === null || _d === void 0 ? void 0 : _d.dataSource);
    }
    else {
        streamDisabled = !config.stream;
    }
    return Object.assign(Object.assign(Object.assign({ customBaseURI: config.serviceEndpoints.polling !== Configuration_1.defaultValues.baseUri, customStreamURI: config.serviceEndpoints.streaming !== Configuration_1.defaultValues.streamUri, customEventsURI: config.serviceEndpoints.events !== Configuration_1.defaultValues.eventsUri, eventsCapacity: config.eventsCapacity, 
        // Node doesn't distinguish between these two kinds of timeouts. It is unlikely other web
        // based implementations would be able to either.
        connectTimeoutMillis: (0, js_sdk_common_1.secondsToMillis)(config.timeout), socketTimeoutMillis: (0, js_sdk_common_1.secondsToMillis)(config.timeout), eventsFlushIntervalMillis: (0, js_sdk_common_1.secondsToMillis)(config.flushInterval) }, (pollingIntervalMillis ? { pollingIntervalMillis } : null)), (reconnectTimeMillis ? { reconnectTimeMillis } : null)), { contextKeysFlushIntervalMillis: (0, js_sdk_common_1.secondsToMillis)(config.contextKeysFlushInterval), diagnosticRecordingIntervalMillis: (0, js_sdk_common_1.secondsToMillis)(config.diagnosticRecordingInterval), streamingDisabled: streamDisabled, usingRelayDaemon: (_f = (_e = config.dataSystem) === null || _e === void 0 ? void 0 : _e.useLdd) !== null && _f !== void 0 ? _f : config.useLdd, offline: config.offline, allAttributesPrivate: config.allAttributesPrivate, contextKeysCapacity: config.contextKeysCapacity, usingProxy: !!((_h = (_g = platform.requests).usingProxy) === null || _h === void 0 ? void 0 : _h.call(_g)), usingProxyAuthenticator: !!((_k = (_j = platform.requests).usingProxyAuth) === null || _k === void 0 ? void 0 : _k.call(_j)), dataStoreType: (_m = (_l = featureStore.getDescription) === null || _l === void 0 ? void 0 : _l.call(featureStore)) !== null && _m !== void 0 ? _m : 'memory' });
};
exports.default = createDiagnosticsInitConfig;
//# sourceMappingURL=createDiagnosticsInitConfig.js.map