"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const NamespacedDataSet_1 = require("./NamespacedDataSet");
/**
 * @internal
 */
class DependencyTracker {
    constructor() {
        this._dependenciesFrom = new NamespacedDataSet_1.default();
        this._dependenciesTo = new NamespacedDataSet_1.default();
    }
    updateDependenciesFrom(namespace, key, newDependencySet) {
        const oldDependencySet = this._dependenciesFrom.get(namespace, key);
        oldDependencySet === null || oldDependencySet === void 0 ? void 0 : oldDependencySet.enumerate((depNs, depKey) => {
            const depsToThisDep = this._dependenciesTo.get(depNs, depKey);
            depsToThisDep === null || depsToThisDep === void 0 ? void 0 : depsToThisDep.remove(namespace, key);
        });
        this._dependenciesFrom.set(namespace, key, newDependencySet);
        newDependencySet === null || newDependencySet === void 0 ? void 0 : newDependencySet.enumerate((depNs, depKey) => {
            let depsToThisDep = this._dependenciesTo.get(depNs, depKey);
            if (!depsToThisDep) {
                depsToThisDep = new NamespacedDataSet_1.default();
                this._dependenciesTo.set(depNs, depKey, depsToThisDep);
            }
            depsToThisDep.set(namespace, key, true);
        });
    }
    updateModifiedItems(inDependencySet, modifiedNamespace, modifiedKey) {
        if (!inDependencySet.get(modifiedNamespace, modifiedKey)) {
            inDependencySet.set(modifiedNamespace, modifiedKey, true);
            const affectedItems = this._dependenciesTo.get(modifiedNamespace, modifiedKey);
            affectedItems === null || affectedItems === void 0 ? void 0 : affectedItems.enumerate((namespace, key) => {
                this.updateModifiedItems(inDependencySet, namespace, key);
            });
        }
    }
    reset() {
        this._dependenciesFrom.removeAll();
        this._dependenciesTo.removeAll();
    }
}
exports.default = DependencyTracker;
//# sourceMappingURL=DependencyTracker.js.map