"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class FlagsStateBuilder {
    constructor(_valid, _withReasons) {
        this._valid = _valid;
        this._withReasons = _withReasons;
        this._flagValues = {};
        this._flagMetadata = {};
    }
    addFlag(flag, value, variation, reason, trackEvents, trackReason, detailsOnlyIfTracked, prerequisites) {
        this._flagValues[flag.key] = value;
        const meta = {};
        if (variation !== undefined) {
            meta.variation = variation;
        }
        const omitDetails = detailsOnlyIfTracked &&
            !trackEvents &&
            !trackReason &&
            flag.debugEventsUntilDate === undefined; // 0 probably doesn't matter.
        if (!omitDetails) {
            meta.version = flag.version;
        }
        if (reason && (trackReason || (this._withReasons && !omitDetails))) {
            meta.reason = reason;
        }
        if (trackEvents) {
            meta.trackEvents = true;
        }
        if (trackReason) {
            meta.trackReason = true;
        }
        if (flag.debugEventsUntilDate !== undefined) {
            meta.debugEventsUntilDate = flag.debugEventsUntilDate;
        }
        if (prerequisites && prerequisites.length) {
            meta.prerequisites = prerequisites;
        }
        this._flagMetadata[flag.key] = meta;
    }
    build() {
        return {
            valid: this._valid,
            allValues: () => this._flagValues,
            getFlagValue: (key) => this._flagValues[key],
            getFlagReason: (key) => { var _a; return (_a = (this._flagMetadata[key] ? this._flagMetadata[key].reason : null)) !== null && _a !== void 0 ? _a : null; },
            toJSON: () => (Object.assign(Object.assign({}, this._flagValues), { $flagsState: this._flagMetadata, $valid: this._valid })),
        };
    }
}
exports.default = FlagsStateBuilder;
//# sourceMappingURL=FlagsStateBuilder.js.map