"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @ignore
 */
class BigSegmentStoreStatusProviderImpl {
    constructor(_onRequestStatus) {
        this._onRequestStatus = _onRequestStatus;
    }
    /**
     * Gets the current status of the store, if known.
     *
     * @returns a {@link BigSegmentStoreStatus}, or `undefined` if the SDK has not yet queried the
     *   Big Segment store status
     */
    getStatus() {
        return this._lastStatus;
    }
    /**
     * Gets the current status of the store, querying it if the status has not already been queried.
     *
     * @returns a Promise for the status of the store
     */
    async requireStatus() {
        if (!this._lastStatus) {
            await this._onRequestStatus();
        }
        // Status will be defined at this point.
        return this._lastStatus;
    }
    notify() {
        var _a;
        if (this._lastStatus) {
            (_a = this._listener) === null || _a === void 0 ? void 0 : _a.call(this, this._lastStatus);
        }
    }
    setListener(listener) {
        this._listener = listener;
    }
    setStatus(status) {
        this._lastStatus = status;
    }
}
exports.default = BigSegmentStoreStatusProviderImpl;
//# sourceMappingURL=BigSegmentStatusProviderImpl.js.map