"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutionHistoryPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var _components = require("../../../components");
var _api = require("../../../lib/api");
var _watch_details_context = require("../watch_details_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const watchHistoryTimeSpanOptions = [{
  value: 'now-1h',
  text: _i18n.i18n.translate('xpack.watcher.sections.watchHistory.timeSpan.1h', {
    defaultMessage: 'Last one hour'
  })
}, {
  value: 'now-24h',
  text: _i18n.i18n.translate('xpack.watcher.sections.watchHistory.timeSpan.24h', {
    defaultMessage: 'Last 24 hours'
  })
}, {
  value: 'now-7d',
  text: _i18n.i18n.translate('xpack.watcher.sections.watchHistory.timeSpan.7d', {
    defaultMessage: 'Last 7 days'
  })
}, {
  value: 'now-30d',
  text: _i18n.i18n.translate('xpack.watcher.sections.watchHistory.timeSpan.30d', {
    defaultMessage: 'Last 30 days'
  })
}, {
  value: 'now-6M',
  text: _i18n.i18n.translate('xpack.watcher.sections.watchHistory.timeSpan.6M', {
    defaultMessage: 'Last 6 months'
  })
}, {
  value: 'now-1y',
  text: _i18n.i18n.translate('xpack.watcher.sections.watchHistory.timeSpan.1y', {
    defaultMessage: 'Last 1 year'
  })
}];
const ExecutionHistoryPanel = () => {
  const {
    watchDetail: loadedWatch
  } = (0, _react.useContext)(_watch_details_context.WatchDetailsContext);
  const [isActivated, setIsActivated] = (0, _react.useState)(undefined);
  const [detailWatchId, setDetailWatchId] = (0, _react.useState)(undefined);
  const [watchHistoryTimeSpan, setWatchHistoryTimeSpan] = (0, _react.useState)(watchHistoryTimeSpanOptions[0].value);
  if (isActivated === undefined) {
    // Set initial value for isActivated based on the watch we just loaded.
    const isActive = loadedWatch.watchStatus && loadedWatch.watchStatus.isActive || false;
    setIsActivated(isActive);
  }
  const {
    error: historyError,
    data: history,
    isLoading
  } = (0, _api.useLoadWatchHistory)(loadedWatch.id, watchHistoryTimeSpan);
  const {
    error: watchHistoryDetailsError,
    data: watchHistoryDetails
  } = (0, _api.useLoadWatchHistoryDetail)(detailWatchId);
  const executionDetail = watchHistoryDetails ? JSON.stringify(watchHistoryDetails.details, null, 2) : '';
  if (historyError) {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_components.SectionError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchHistory.watchExecutionErrorTitle",
        defaultMessage: "Error loading execution history"
      }),
      error: historyError
    }));
  }
  const columns = [{
    field: 'startTime',
    name: _i18n.i18n.translate('xpack.watcher.sections.watchHistory.watchTable.startTimeHeader', {
      defaultMessage: 'Trigger time'
    }),
    sortable: true,
    truncateText: false,
    // TODO: Once we convert the client-side models to TS, this should be a WatchHistoryItemModel.
    render: (startTime, item) => {
      const formattedDate = startTime.format();
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": `watchStartTimeColumn-${formattedDate}`,
        onClick: () => setDetailWatchId(item.id)
      }, formattedDate);
    }
  }, {
    field: 'watchStatus.state',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.watcher.sections.watchHistory.watchTable.stateHeader.tooltipText', {
        defaultMessage: 'Active or error state.'
      })
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.watcher.sections.watchHistory.watchTable.stateHeader', {
      defaultMessage: 'State'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignTop"
    }))),
    sortable: true,
    truncateText: true,
    render: state => /*#__PURE__*/_react.default.createElement(_components.WatchStateBadge, {
      state: state
    })
  }, {
    field: 'startTime',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.watcher.sections.watchHistory.watchTable.metConditionHeader.tooltipText', {
        defaultMessage: 'Whether the condition was met and action taken.'
      })
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.watcher.sections.watchHistory.watchTable.metConditionHeader', {
      defaultMessage: 'Condition met'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignTop"
    }))),
    sortable: true,
    truncateText: true,
    // TODO: Once we convert the client-side models to TS, this should be a WatchHistoryItemModel.
    render: (startTime, item) => {
      const {
        watchStatus: {
          lastExecution
        }
      } = item;
      if (startTime.isSame(lastExecution)) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          color: "green",
          type: "check"
        });
      }
    }
  }, {
    field: 'watchStatus.comment',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.watcher.sections.watchHistory.watchTable.commentHeader.tooltipText', {
        defaultMessage: 'Whether the action was throttled, acknowledged, or failed to execute.'
      })
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.watcher.sections.watchHistory.watchTable.commentHeader', {
      defaultMessage: 'Comment'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignTop"
    }))),
    sortable: true,
    truncateText: true
  }];
  const onTimespanChange = e => {
    const timespan = e.target.value;
    setWatchHistoryTimeSpan(timespan);
  };
  let flyout;
  if (detailWatchId !== undefined) {
    if (watchHistoryDetailsError) {
      flyout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
        "data-test-subj": "watchHistoryErrorDetailFlyout",
        onClose: () => setDetailWatchId(undefined),
        "aria-labelledby": "watchHistoryErrorDetailsFlyoutTitle",
        maxWidth: 600
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h3", {
        "data-test-subj": "title"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchHistory.watchHistoryDetail.errorTitle",
        defaultMessage: "Execution details"
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_components.SectionError, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.watcher.sections.watchHistory.watchHistoryDetailsErrorTitle",
          defaultMessage: "Error loading execution details"
        }),
        error: watchHistoryDetailsError,
        "data-test-subj": "errorMessage"
      })));
    }
    if (watchHistoryDetails !== undefined) {
      var _watchHistoryDetails$;
      const detailColumns = [{
        field: 'id',
        name: _i18n.i18n.translate('xpack.watcher.sections.watchHistory.watchActionStatusTable.id', {
          defaultMessage: 'Name'
        }),
        sortable: true,
        truncateText: false
      }, {
        field: 'state',
        name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: _i18n.i18n.translate('xpack.watcher.sections.watchHistory.watchActionStatusTable.state.tooltipText', {
            defaultMessage: 'OK, acknowledged, throttled, or error.'
          })
        }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.watcher.sections.watchHistory.watchActionStatusTable.state', {
          defaultMessage: 'State'
        }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "s",
          color: "subdued",
          type: "question",
          className: "eui-alignTop"
        }))),
        sortable: true,
        truncateText: true,
        render: state => /*#__PURE__*/_react.default.createElement(_components.ActionStateBadge, {
          state: state
        })
      }];
      flyout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
        "data-test-subj": "watchHistoryDetailFlyout",
        onClose: () => setDetailWatchId(undefined),
        "aria-labelledby": "watchHistoryDetailsFlyoutTitle",
        maxWidth: 600
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h3", {
        "data-test-subj": "title"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchHistory.watchHistoryDetail.title",
        defaultMessage: "Executed on {date}",
        values: {
          date: (_watchHistoryDetails$ = watchHistoryDetails.startTime) === null || _watchHistoryDetails$ === void 0 ? void 0 : _watchHistoryDetails$.format()
        }
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchHistory.watchHistoryDetail.actionsTitle",
        defaultMessage: "Actions"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
        items: watchHistoryDetails.watchStatus.actionStatuses,
        itemId: "id",
        columns: detailColumns,
        message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.watcher.sections.watchHistory.watchTable.noWatchesMessage",
          defaultMessage: "No current status to show"
        }),
        "data-test-subj": "watchActionsTable"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchHistory.watchHistoryDetail.jsonTitle",
        defaultMessage: "JSON"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        language: "json"
      }, executionDetail)));
    }
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "watchHistorySection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexStart",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: watchHistoryTimeSpanOptions,
    value: watchHistoryTimeSpan,
    onChange: onTimespanChange,
    "aria-label": _i18n.i18n.translate('xpack.watcher.sections.watchHistory.changeTimespanSelectAriaLabel', {
      defaultMessage: 'Change timespan of watch history'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: history || [],
    columns: columns,
    pagination: _constants.PAGINATION,
    sorting: true,
    loading: isLoading,
    "data-test-subj": "watchHistoryTable",
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchHistory.watchTable.noCurrentStatus",
      defaultMessage: "No execution history to show"
    })
  }), flyout);
};
exports.ExecutionHistoryPanel = ExecutionHistoryPanel;