"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexActionFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _form_errors = require("../../../../../components/form_errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexActionFields = ({
  action,
  editAction,
  errors,
  hasErrors
}) => {
  const {
    index
  } = action;
  return /*#__PURE__*/_react.default.createElement(_form_errors.ErrableFormRow, {
    id: "indexName",
    errorKey: "index",
    fullWidth: true,
    errors: errors,
    isShowingErrors: hasErrors && index !== undefined,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.indexAction.indexFieldLabel', {
      defaultMessage: 'Index'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    name: "index",
    "data-test-subj": "indexInput",
    value: index || '',
    onChange: e => {
      editAction({
        key: 'index',
        value: e.target.value
      });
    },
    onBlur: () => {
      if (!index) {
        editAction({
          key: 'index',
          value: ''
        });
      }
    }
  }));
};
exports.IndexActionFields = IndexActionFields;