"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoggingAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _base_action = require("./base_action");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LoggingAction extends _base_action.BaseAction {
  constructor(props = {}) {
    super(props);
    const defaultText = _i18n.i18n.translate('xpack.watcher.models.loggingAction.defaultText', {
      defaultMessage: 'Watch [{context}] has exceeded the threshold',
      values: {
        context: '{{ctx.metadata.name}}'
      }
    });
    this.text = (0, _lodash.get)(props, 'text', props.ignoreDefaults ? null : defaultText);
  }
  validate() {
    const errors = {
      text: []
    };
    if (!this.text) {
      errors.text.push(_i18n.i18n.translate('xpack.watcher.watchActions.logging.logTextIsRequiredValidationMessage', {
        defaultMessage: 'Log text is required.'
      }));
    }
    return errors;
  }
  get upstreamJson() {
    const result = super.upstreamJson;
    let text;
    if (typeof this.text === 'string') {
      // If this.text is a non-empty string, we can send it to the API.
      if (!!this.text.trim()) {
        text = this.text;
      }
    } else {
      // If the user incorrectly defined this.text, e.g. as an object in a JSON watch, let the API
      // deal with it.
      text = this.text;
    }
    Object.assign(result, {
      text,
      logging: {
        text
      }
    });
    return result;
  }
  get simulateMessage() {
    return _i18n.i18n.translate('xpack.watcher.models.loggingAction.simulateMessage', {
      defaultMessage: 'Sample message logged'
    });
  }
  get simulateFailMessage() {
    return _i18n.i18n.translate('xpack.watcher.models.loggingAction.simulateFailMessage', {
      defaultMessage: 'Failed to log sample message.'
    });
  }
  static fromUpstreamJson(upstreamAction) {
    return new LoggingAction(upstreamAction);
  }
}
exports.LoggingAction = LoggingAction;
(0, _defineProperty2.default)(LoggingAction, "typeName", _i18n.i18n.translate('xpack.watcher.models.loggingAction.typeName', {
  defaultMessage: 'Logging'
}));
(0, _defineProperty2.default)(LoggingAction, "iconClass", 'logsApp');
(0, _defineProperty2.default)(LoggingAction, "selectMessage", _i18n.i18n.translate('xpack.watcher.models.loggingAction.selectMessageText', {
  defaultMessage: 'Add an item to the logs.'
}));
(0, _defineProperty2.default)(LoggingAction, "simulatePrompt", _i18n.i18n.translate('xpack.watcher.models.loggingAction.simulateButtonLabel', {
  defaultMessage: 'Log a sample message'
}));