"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JiraAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _base_action = require("./base_action");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class JiraAction extends _base_action.BaseAction {
  constructor(props = {}) {
    super(props);
    const defaultSummary = _i18n.i18n.translate('xpack.watcher.models.jiraAction.defaultSummaryText', {
      defaultMessage: 'Watch [{context}] has exceeded the threshold',
      values: {
        context: '{{ctx.metadata.name}}'
      }
    });
    this.summary = (0, _lodash.get)(props, 'summary', props.ignoreDefaults ? null : defaultSummary);
    this.projectKey = (0, _lodash.get)(props, 'projectKey');
    this.issueType = (0, _lodash.get)(props, 'issueType');
  }
  validate() {
    const errors = {
      projectKey: [],
      issueType: [],
      summary: []
    };
    if (!this.projectKey) {
      errors.projectKey.push(_i18n.i18n.translate('xpack.watcher.watchActions.jira.projectKeyIsRequiredValidationMessage', {
        defaultMessage: 'Jira project key is required.'
      }));
    }
    if (!this.issueType) {
      errors.issueType.push(_i18n.i18n.translate('xpack.watcher.watchActions.jira.issueTypeNameIsRequiredValidationMessage', {
        defaultMessage: 'Jira issue type is required.'
      }));
    }
    if (!this.summary) {
      errors.summary.push(_i18n.i18n.translate('xpack.watcher.watchActions.jira.summaryIsRequiredValidationMessage', {
        defaultMessage: 'Jira summary is required.'
      }));
    }
    return errors;
  }
  get upstreamJson() {
    const result = super.upstreamJson;
    Object.assign(result, {
      projectKey: this.projectKey,
      issueType: this.issueType,
      summary: this.summary,
      jira: {
        fields: {
          project: {
            key: this.projectKey
          },
          issuetype: {
            name: this.issueType
          },
          summary: this.summary
        }
      }
    });
    return result;
  }
  get simulateMessage() {
    return _i18n.i18n.translate('xpack.watcher.models.jiraAction.simulateMessage', {
      defaultMessage: 'Jira issue has been created.'
    });
  }
  get simulateFailMessage() {
    return _i18n.i18n.translate('xpack.watcher.models.jiraAction.simulateFailMessage', {
      defaultMessage: 'Failed to create Jira issue.'
    });
  }
  static fromUpstreamJson(upstreamAction) {
    return new JiraAction(upstreamAction);
  }
}
exports.JiraAction = JiraAction;
(0, _defineProperty2.default)(JiraAction, "typeName", _i18n.i18n.translate('xpack.watcher.models.jiraAction.typeName', {
  defaultMessage: 'Jira'
}));
(0, _defineProperty2.default)(JiraAction, "iconClass", 'apps');
(0, _defineProperty2.default)(JiraAction, "selectMessage", _i18n.i18n.translate('xpack.watcher.models.jiraAction.selectMessageText', {
  defaultMessage: 'Create an issue in Atlassian’s Jira Software.'
}));
(0, _defineProperty2.default)(JiraAction, "simulatePrompt", _i18n.i18n.translate('xpack.watcher.models.jiraAction.simulateButtonLabel', {
  defaultMessage: 'Create a sample Jira issue'
}));