"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageErrorNotExist = PageErrorNotExist;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PageErrorNotExist({
  id
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    iconType: "warning",
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.pageErrorNotExist.title",
      defaultMessage: "Couldn't find watch"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, id ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.pageErrorNotExist.description",
      defaultMessage: "A watch with ID ''{id}'' could not be found.",
      values: {
        id
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.pageErrorNotExist.noWatchIdDescription",
      defaultMessage: "A watch could not be found."
    }))
  });
}