"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCreateBreadcrumbs = getCreateBreadcrumbs;
exports.getCreateServerlessBreadcrumbs = getCreateServerlessBreadcrumbs;
exports.getEditBreadcrumbs = getEditBreadcrumbs;
exports.getEditServerlessBreadcrumbs = getEditServerlessBreadcrumbs;
exports.getLandingBreadcrumbs = getLandingBreadcrumbs;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const defaultEditText = _i18n.i18n.translate('visualizations.editor.defaultEditBreadcrumbText', {
  defaultMessage: 'Edit visualization'
});
function getLandingBreadcrumbs() {
  return [{
    text: _i18n.i18n.translate('visualizations.listing.breadcrumb', {
      defaultMessage: 'Visualize Library'
    }),
    href: `#${_constants.VisualizeConstants.LANDING_PAGE_PATH}`
  }];
}
function getCreateBreadcrumbs({
  byValue,
  originatingAppName,
  redirectToOrigin
}) {
  return [...(originatingAppName ? [{
    text: originatingAppName,
    onClick: redirectToOrigin
  }] : []), ...(!byValue ? getLandingBreadcrumbs() : []), {
    text: _i18n.i18n.translate('visualizations.editor.createBreadcrumb', {
      defaultMessage: 'Create'
    })
  }];
}
function getCreateServerlessBreadcrumbs({
  byValue,
  originatingAppName,
  redirectToOrigin
}) {
  // TODO: https://github.com/elastic/kibana/issues/163488
  // for now, serverless breadcrumbs only set the title,
  // the rest of the breadcrumbs are handled by the serverless navigation
  // the serverless navigation is not yet aware of the byValue/originatingApp context
  return [{
    text: _i18n.i18n.translate('visualizations.editor.createBreadcrumb', {
      defaultMessage: 'Create'
    })
  }];
}
function getEditBreadcrumbs({
  byValue,
  originatingAppName,
  redirectToOrigin
}, title = defaultEditText) {
  return [...(originatingAppName ? [{
    text: originatingAppName,
    onClick: redirectToOrigin
  }] : []), ...(!byValue ? getLandingBreadcrumbs() : []), {
    text: title
  }];
}
function getEditServerlessBreadcrumbs({
  byValue,
  originatingAppName,
  redirectToOrigin
}, title = defaultEditText) {
  // TODO: https://github.com/elastic/kibana/issues/163488
  // for now, serverless breadcrumbs only set the title,
  // the rest of the breadcrumbs are handled by the serverless navigation
  // the serverless navigation is not yet aware of the byValue/originatingApp context
  return [{
    text: title
  }];
}